/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.rocketmq.consumer;

import io.openmessaging.BytesMessage;
import io.openmessaging.KeyValue;
import io.openmessaging.Message;
import io.openmessaging.OMS;
import io.openmessaging.consumer.MessageListener;
import io.openmessaging.consumer.PushConsumer;
import io.openmessaging.exception.OMSRuntimeException;
import io.openmessaging.interceptor.ConsumerInterceptor;
import io.openmessaging.rocketmq.config.ClientConfig;
import io.openmessaging.rocketmq.utils.BeanUtils;
import io.openmessaging.rocketmq.utils.OMSUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.remoting.protocol.LanguageCode;

public class PushConsumerImpl
implements PushConsumer {
    private final DefaultMQPushConsumer rocketmqPushConsumer;
    private final KeyValue properties;
    private boolean started = false;
    private final Map<String, MessageListener> subscribeTable = new ConcurrentHashMap<String, MessageListener>();
    private final ClientConfig clientConfig;

    public PushConsumerImpl(KeyValue properties) {
        String consumerGroup;
        this.rocketmqPushConsumer = new DefaultMQPushConsumer();
        this.properties = properties;
        this.clientConfig = (ClientConfig)((Object)BeanUtils.populate(properties, ClientConfig.class));
        if ("true".equalsIgnoreCase(System.getenv("OMS_RMQ_DIRECT_NAME_SRV"))) {
            String accessPoints = this.clientConfig.getAccessPoints();
            if (accessPoints == null || accessPoints.isEmpty()) {
                throw new OMSRuntimeException("-1", "OMS AccessPoints is null or empty.");
            }
            this.rocketmqPushConsumer.setNamesrvAddr(accessPoints.replace(',', ';'));
        }
        if (null == (consumerGroup = this.clientConfig.getConsumerId()) || consumerGroup.isEmpty()) {
            throw new OMSRuntimeException("-1", "Consumer Group is necessary for RocketMQ, please set it.");
        }
        this.rocketmqPushConsumer.setConsumerGroup(consumerGroup);
        this.rocketmqPushConsumer.setMaxReconsumeTimes(this.clientConfig.getRmqMaxRedeliveryTimes());
        this.rocketmqPushConsumer.setConsumeTimeout((long)this.clientConfig.getRmqMessageConsumeTimeout());
        this.rocketmqPushConsumer.setConsumeThreadMax(this.clientConfig.getRmqMaxConsumeThreadNums());
        this.rocketmqPushConsumer.setConsumeThreadMin(this.clientConfig.getRmqMinConsumeThreadNums());
        String consumerId = OMSUtil.buildInstanceName();
        this.rocketmqPushConsumer.setInstanceName(consumerId);
        properties.put("CONSUMER_ID", consumerId);
        this.rocketmqPushConsumer.setLanguage(LanguageCode.OMS);
        this.rocketmqPushConsumer.registerMessageListener((MessageListenerConcurrently)new MessageListenerImpl());
    }

    public KeyValue attributes() {
        return this.properties;
    }

    public void resume() {
        this.rocketmqPushConsumer.resume();
    }

    public void suspend() {
        this.rocketmqPushConsumer.suspend();
    }

    public void suspend(long timeout) {
    }

    public boolean isSuspended() {
        return this.rocketmqPushConsumer.getDefaultMQPushConsumerImpl().isPause();
    }

    public PushConsumer attachQueue(String queueName, MessageListener listener) {
        this.subscribeTable.put(queueName, listener);
        try {
            this.rocketmqPushConsumer.subscribe(queueName, "*");
        }
        catch (MQClientException e) {
            throw new OMSRuntimeException("-1", String.format("RocketMQ push consumer can't attach to %s.", queueName));
        }
        return this;
    }

    public PushConsumer attachQueue(String queueName, MessageListener listener, KeyValue attributes) {
        return this.attachQueue(queueName, listener);
    }

    public PushConsumer detachQueue(String queueName) {
        this.subscribeTable.remove(queueName);
        try {
            this.rocketmqPushConsumer.unsubscribe(queueName);
        }
        catch (Exception e) {
            throw new OMSRuntimeException("-1", String.format("RocketMQ push consumer fails to unsubscribe topic: %s", queueName));
        }
        return null;
    }

    public void addInterceptor(ConsumerInterceptor interceptor) {
    }

    public void removeInterceptor(ConsumerInterceptor interceptor) {
    }

    public synchronized void startup() {
        if (!this.started) {
            try {
                this.rocketmqPushConsumer.start();
            }
            catch (MQClientException e) {
                throw new OMSRuntimeException("-1", (Throwable)e);
            }
        }
        this.started = true;
    }

    public synchronized void shutdown() {
        if (this.started) {
            this.rocketmqPushConsumer.shutdown();
        }
        this.started = false;
    }

    class MessageListenerImpl
    implements MessageListenerConcurrently {
        MessageListenerImpl() {
        }

        public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> rmqMsgList, ConsumeConcurrentlyContext contextRMQ) {
            MessageExt rmqMsg = rmqMsgList.get(0);
            BytesMessage omsMsg = OMSUtil.msgConvert(rmqMsg);
            MessageListener listener = (MessageListener)PushConsumerImpl.this.subscribeTable.get(rmqMsg.getTopic());
            if (listener == null) {
                throw new OMSRuntimeException("-1", String.format("The topic/queue %s isn't attached to this consumer", rmqMsg.getTopic()));
            }
            final KeyValue contextProperties = OMS.newKeyValue();
            final CountDownLatch sync = new CountDownLatch(1);
            contextProperties.put("rmq.message.consume.status", ConsumeConcurrentlyStatus.RECONSUME_LATER.name());
            MessageListener.Context context = new MessageListener.Context(){

                public KeyValue attributes() {
                    return contextProperties;
                }

                public void ack() {
                    sync.countDown();
                    contextProperties.put("rmq.message.consume.status", ConsumeConcurrentlyStatus.CONSUME_SUCCESS.name());
                }
            };
            long begin = System.currentTimeMillis();
            listener.onReceived((Message)omsMsg, context);
            long costs = System.currentTimeMillis() - begin;
            long timeoutMills = PushConsumerImpl.this.clientConfig.getRmqMessageConsumeTimeout() * 60 * 1000;
            try {
                sync.await(Math.max(0L, timeoutMills - costs), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return ConsumeConcurrentlyStatus.valueOf((String)contextProperties.getString("rmq.message.consume.status"));
        }
    }
}

