/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.channel;

import com.google.common.base.Strings;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.service.channel.InvocationContextInterface;
import org.apache.rocketmq.proxy.service.channel.SimpleChannelHandlerContext;

public class SimpleChannel
extends AbstractChannel {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    protected final String remoteAddress;
    protected final String localAddress;
    protected long lastAccessTime = System.currentTimeMillis();
    protected ChannelHandlerContext channelHandlerContext;

    public SimpleChannel(Channel parent, String remoteAddress, String localAddress) {
        this(parent, null, remoteAddress, localAddress);
    }

    public SimpleChannel(Channel parent, ChannelId id, String remoteAddress, String localAddress) {
        super(parent, id);
        this.remoteAddress = remoteAddress;
        this.localAddress = localAddress;
        this.channelHandlerContext = new SimpleChannelHandlerContext((Channel)this);
    }

    public SimpleChannel(String remoteAddress, String localAddress) {
        this(null, remoteAddress, localAddress);
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return null;
    }

    protected boolean isCompatible(EventLoop loop) {
        return false;
    }

    private static SocketAddress parseSocketAddress(String address) {
        if (Strings.isNullOrEmpty((String)address)) {
            return null;
        }
        String[] segments = address.split(":");
        if (2 == segments.length) {
            return new InetSocketAddress(segments[0], Integer.parseInt(segments[1]));
        }
        return null;
    }

    protected SocketAddress localAddress0() {
        return SimpleChannel.parseSocketAddress(this.localAddress);
    }

    public SocketAddress localAddress() {
        return this.localAddress0();
    }

    public SocketAddress remoteAddress() {
        return this.remoteAddress0();
    }

    protected SocketAddress remoteAddress0() {
        return SimpleChannel.parseSocketAddress(this.remoteAddress);
    }

    protected void doBind(SocketAddress localAddress) throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    public ChannelFuture close() {
        DefaultChannelPromise promise = new DefaultChannelPromise((Channel)this, (EventExecutor)GlobalEventExecutor.INSTANCE);
        promise.setSuccess();
        return promise;
    }

    protected void doClose() throws Exception {
    }

    protected void doBeginRead() throws Exception {
    }

    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
    }

    public ChannelConfig config() {
        return null;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isActive() {
        return System.currentTimeMillis() - this.lastAccessTime <= 120000L;
    }

    public ChannelMetadata metadata() {
        return null;
    }

    public ChannelFuture writeAndFlush(Object msg) {
        DefaultChannelPromise promise = new DefaultChannelPromise((Channel)this, (EventExecutor)GlobalEventExecutor.INSTANCE);
        promise.setSuccess();
        return promise;
    }

    public boolean isWritable() {
        return true;
    }

    public void updateLastAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public void registerInvocationContext(int opaque, InvocationContextInterface context) {
    }

    public void eraseInvocationContext(int opaque) {
    }

    public void clearExpireContext() {
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.channelHandlerContext;
    }
}

