/*
 * Decompiled with CFR 0.152.
 */
package apache.rocketmq.v2;

import apache.rocketmq.v2.Broker;
import apache.rocketmq.v2.BrokerOrBuilder;
import apache.rocketmq.v2.MQDomain;
import apache.rocketmq.v2.MessageQueueOrBuilder;
import apache.rocketmq.v2.MessageType;
import apache.rocketmq.v2.Permission;
import apache.rocketmq.v2.Resource;
import apache.rocketmq.v2.ResourceOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MessageQueue
extends GeneratedMessageV3
implements MessageQueueOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int TOPIC_FIELD_NUMBER = 1;
    private Resource topic_;
    public static final int ID_FIELD_NUMBER = 2;
    private int id_;
    public static final int PERMISSION_FIELD_NUMBER = 3;
    private int permission_;
    public static final int BROKER_FIELD_NUMBER = 4;
    private Broker broker_;
    public static final int ACCEPT_MESSAGE_TYPES_FIELD_NUMBER = 5;
    private List<Integer> acceptMessageTypes_;
    private static final Internal.ListAdapter.Converter<Integer, MessageType> acceptMessageTypes_converter_ = new Internal.ListAdapter.Converter<Integer, MessageType>(){

        public MessageType convert(Integer from) {
            MessageType result = MessageType.valueOf(from);
            return result == null ? MessageType.UNRECOGNIZED : result;
        }
    };
    private int acceptMessageTypesMemoizedSerializedSize;
    private byte memoizedIsInitialized = (byte)-1;
    private static final MessageQueue DEFAULT_INSTANCE = new MessageQueue();
    private static final Parser<MessageQueue> PARSER = new AbstractParser<MessageQueue>(){

        public MessageQueue parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new MessageQueue(input, extensionRegistry);
        }
    };

    private MessageQueue(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private MessageQueue() {
        this.permission_ = 0;
        this.acceptMessageTypes_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new MessageQueue();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private MessageQueue(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        boolean mutable_bitField0_ = false;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block16: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block16;
                    }
                    case 10: {
                        Resource.Builder subBuilder = null;
                        if (this.topic_ != null) {
                            subBuilder = this.topic_.toBuilder();
                        }
                        this.topic_ = (Resource)input.readMessage(Resource.parser(), extensionRegistry);
                        if (subBuilder == null) continue block16;
                        subBuilder.mergeFrom(this.topic_);
                        this.topic_ = subBuilder.buildPartial();
                        continue block16;
                    }
                    case 16: {
                        this.id_ = input.readInt32();
                        continue block16;
                    }
                    case 24: {
                        int rawValue;
                        this.permission_ = rawValue = input.readEnum();
                        continue block16;
                    }
                    case 34: {
                        Broker.Builder subBuilder = null;
                        if (this.broker_ != null) {
                            subBuilder = this.broker_.toBuilder();
                        }
                        this.broker_ = (Broker)input.readMessage(Broker.parser(), extensionRegistry);
                        if (subBuilder == null) continue block16;
                        subBuilder.mergeFrom(this.broker_);
                        this.broker_ = subBuilder.buildPartial();
                        continue block16;
                    }
                    case 40: {
                        int rawValue = input.readEnum();
                        if (!(mutable_bitField0_ & true)) {
                            this.acceptMessageTypes_ = new ArrayList<Integer>();
                            mutable_bitField0_ |= true;
                        }
                        this.acceptMessageTypes_.add(rawValue);
                        continue block16;
                    }
                    case 42: {
                        int length = input.readRawVarint32();
                        int oldLimit = input.pushLimit(length);
                        while (input.getBytesUntilLimit() > 0) {
                            int rawValue = input.readEnum();
                            if (!(mutable_bitField0_ & true)) {
                                this.acceptMessageTypes_ = new ArrayList<Integer>();
                                mutable_bitField0_ |= true;
                            }
                            this.acceptMessageTypes_.add(rawValue);
                        }
                        input.popLimit(oldLimit);
                        continue block16;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.acceptMessageTypes_ = Collections.unmodifiableList(this.acceptMessageTypes_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return MQDomain.internal_static_apache_rocketmq_v2_MessageQueue_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return MQDomain.internal_static_apache_rocketmq_v2_MessageQueue_fieldAccessorTable.ensureFieldAccessorsInitialized(MessageQueue.class, Builder.class);
    }

    @Override
    public boolean hasTopic() {
        return this.topic_ != null;
    }

    @Override
    public Resource getTopic() {
        return this.topic_ == null ? Resource.getDefaultInstance() : this.topic_;
    }

    @Override
    public ResourceOrBuilder getTopicOrBuilder() {
        return this.getTopic();
    }

    @Override
    public int getId() {
        return this.id_;
    }

    @Override
    public int getPermissionValue() {
        return this.permission_;
    }

    @Override
    public Permission getPermission() {
        Permission result = Permission.valueOf(this.permission_);
        return result == null ? Permission.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasBroker() {
        return this.broker_ != null;
    }

    @Override
    public Broker getBroker() {
        return this.broker_ == null ? Broker.getDefaultInstance() : this.broker_;
    }

    @Override
    public BrokerOrBuilder getBrokerOrBuilder() {
        return this.getBroker();
    }

    @Override
    public List<MessageType> getAcceptMessageTypesList() {
        return new Internal.ListAdapter(this.acceptMessageTypes_, acceptMessageTypes_converter_);
    }

    @Override
    public int getAcceptMessageTypesCount() {
        return this.acceptMessageTypes_.size();
    }

    @Override
    public MessageType getAcceptMessageTypes(int index) {
        return (MessageType)((Object)acceptMessageTypes_converter_.convert((Object)this.acceptMessageTypes_.get(index)));
    }

    @Override
    public List<Integer> getAcceptMessageTypesValueList() {
        return this.acceptMessageTypes_;
    }

    @Override
    public int getAcceptMessageTypesValue(int index) {
        return this.acceptMessageTypes_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        this.getSerializedSize();
        if (this.topic_ != null) {
            output.writeMessage(1, (MessageLite)this.getTopic());
        }
        if (this.id_ != 0) {
            output.writeInt32(2, this.id_);
        }
        if (this.permission_ != Permission.PERMISSION_UNSPECIFIED.getNumber()) {
            output.writeEnum(3, this.permission_);
        }
        if (this.broker_ != null) {
            output.writeMessage(4, (MessageLite)this.getBroker());
        }
        if (this.getAcceptMessageTypesList().size() > 0) {
            output.writeUInt32NoTag(42);
            output.writeUInt32NoTag(this.acceptMessageTypesMemoizedSerializedSize);
        }
        for (int i = 0; i < this.acceptMessageTypes_.size(); ++i) {
            output.writeEnumNoTag(this.acceptMessageTypes_.get(i).intValue());
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.topic_ != null) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getTopic());
        }
        if (this.id_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)2, (int)this.id_);
        }
        if (this.permission_ != Permission.PERMISSION_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.permission_);
        }
        if (this.broker_ != null) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getBroker());
        }
        int dataSize = 0;
        for (int i = 0; i < this.acceptMessageTypes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.acceptMessageTypes_.get(i));
        }
        size += dataSize;
        if (!this.getAcceptMessageTypesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.acceptMessageTypesMemoizedSerializedSize = dataSize;
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MessageQueue)) {
            return super.equals(obj);
        }
        MessageQueue other = (MessageQueue)obj;
        if (this.hasTopic() != other.hasTopic()) {
            return false;
        }
        if (this.hasTopic() && !this.getTopic().equals(other.getTopic())) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.permission_ != other.permission_) {
            return false;
        }
        if (this.hasBroker() != other.hasBroker()) {
            return false;
        }
        if (this.hasBroker() && !this.getBroker().equals(other.getBroker())) {
            return false;
        }
        if (!this.acceptMessageTypes_.equals(other.acceptMessageTypes_)) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + MessageQueue.getDescriptor().hashCode();
        if (this.hasTopic()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getTopic().hashCode();
        }
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getId();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.permission_;
        if (this.hasBroker()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getBroker().hashCode();
        }
        if (this.getAcceptMessageTypesCount() > 0) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.acceptMessageTypes_.hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static MessageQueue parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (MessageQueue)PARSER.parseFrom(data);
    }

    public static MessageQueue parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MessageQueue)PARSER.parseFrom(data, extensionRegistry);
    }

    public static MessageQueue parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (MessageQueue)PARSER.parseFrom(data);
    }

    public static MessageQueue parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MessageQueue)PARSER.parseFrom(data, extensionRegistry);
    }

    public static MessageQueue parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (MessageQueue)PARSER.parseFrom(data);
    }

    public static MessageQueue parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MessageQueue)PARSER.parseFrom(data, extensionRegistry);
    }

    public static MessageQueue parseFrom(InputStream input) throws IOException {
        return (MessageQueue)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static MessageQueue parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (MessageQueue)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static MessageQueue parseDelimitedFrom(InputStream input) throws IOException {
        return (MessageQueue)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static MessageQueue parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (MessageQueue)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static MessageQueue parseFrom(CodedInputStream input) throws IOException {
        return (MessageQueue)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static MessageQueue parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (MessageQueue)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return MessageQueue.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(MessageQueue prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static MessageQueue getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<MessageQueue> parser() {
        return PARSER;
    }

    public Parser<MessageQueue> getParserForType() {
        return PARSER;
    }

    public MessageQueue getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements MessageQueueOrBuilder {
        private int bitField0_;
        private Resource topic_;
        private SingleFieldBuilderV3<Resource, Resource.Builder, ResourceOrBuilder> topicBuilder_;
        private int id_;
        private int permission_ = 0;
        private Broker broker_;
        private SingleFieldBuilderV3<Broker, Broker.Builder, BrokerOrBuilder> brokerBuilder_;
        private List<Integer> acceptMessageTypes_ = Collections.emptyList();

        public static final Descriptors.Descriptor getDescriptor() {
            return MQDomain.internal_static_apache_rocketmq_v2_MessageQueue_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return MQDomain.internal_static_apache_rocketmq_v2_MessageQueue_fieldAccessorTable.ensureFieldAccessorsInitialized(MessageQueue.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                // empty if block
            }
        }

        public Builder clear() {
            super.clear();
            if (this.topicBuilder_ == null) {
                this.topic_ = null;
            } else {
                this.topic_ = null;
                this.topicBuilder_ = null;
            }
            this.id_ = 0;
            this.permission_ = 0;
            if (this.brokerBuilder_ == null) {
                this.broker_ = null;
            } else {
                this.broker_ = null;
                this.brokerBuilder_ = null;
            }
            this.acceptMessageTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return MQDomain.internal_static_apache_rocketmq_v2_MessageQueue_descriptor;
        }

        public MessageQueue getDefaultInstanceForType() {
            return MessageQueue.getDefaultInstance();
        }

        public MessageQueue build() {
            MessageQueue result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public MessageQueue buildPartial() {
            MessageQueue result = new MessageQueue(this);
            int from_bitField0_ = this.bitField0_;
            if (this.topicBuilder_ == null) {
                result.topic_ = this.topic_;
            } else {
                result.topic_ = (Resource)this.topicBuilder_.build();
            }
            result.id_ = this.id_;
            result.permission_ = this.permission_;
            if (this.brokerBuilder_ == null) {
                result.broker_ = this.broker_;
            } else {
                result.broker_ = (Broker)this.brokerBuilder_.build();
            }
            if ((this.bitField0_ & 1) != 0) {
                this.acceptMessageTypes_ = Collections.unmodifiableList(this.acceptMessageTypes_);
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.acceptMessageTypes_ = this.acceptMessageTypes_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof MessageQueue) {
                return this.mergeFrom((MessageQueue)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(MessageQueue other) {
            if (other == MessageQueue.getDefaultInstance()) {
                return this;
            }
            if (other.hasTopic()) {
                this.mergeTopic(other.getTopic());
            }
            if (other.getId() != 0) {
                this.setId(other.getId());
            }
            if (other.permission_ != 0) {
                this.setPermissionValue(other.getPermissionValue());
            }
            if (other.hasBroker()) {
                this.mergeBroker(other.getBroker());
            }
            if (!other.acceptMessageTypes_.isEmpty()) {
                if (this.acceptMessageTypes_.isEmpty()) {
                    this.acceptMessageTypes_ = other.acceptMessageTypes_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureAcceptMessageTypesIsMutable();
                    this.acceptMessageTypes_.addAll(other.acceptMessageTypes_);
                }
                this.onChanged();
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            MessageQueue parsedMessage = null;
            try {
                parsedMessage = (MessageQueue)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (MessageQueue)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public boolean hasTopic() {
            return this.topicBuilder_ != null || this.topic_ != null;
        }

        @Override
        public Resource getTopic() {
            if (this.topicBuilder_ == null) {
                return this.topic_ == null ? Resource.getDefaultInstance() : this.topic_;
            }
            return (Resource)this.topicBuilder_.getMessage();
        }

        public Builder setTopic(Resource value) {
            if (this.topicBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.topic_ = value;
                this.onChanged();
            } else {
                this.topicBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setTopic(Resource.Builder builderForValue) {
            if (this.topicBuilder_ == null) {
                this.topic_ = builderForValue.build();
                this.onChanged();
            } else {
                this.topicBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeTopic(Resource value) {
            if (this.topicBuilder_ == null) {
                this.topic_ = this.topic_ != null ? Resource.newBuilder(this.topic_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.topicBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearTopic() {
            if (this.topicBuilder_ == null) {
                this.topic_ = null;
                this.onChanged();
            } else {
                this.topic_ = null;
                this.topicBuilder_ = null;
            }
            return this;
        }

        public Resource.Builder getTopicBuilder() {
            this.onChanged();
            return (Resource.Builder)this.getTopicFieldBuilder().getBuilder();
        }

        @Override
        public ResourceOrBuilder getTopicOrBuilder() {
            if (this.topicBuilder_ != null) {
                return (ResourceOrBuilder)this.topicBuilder_.getMessageOrBuilder();
            }
            return this.topic_ == null ? Resource.getDefaultInstance() : this.topic_;
        }

        private SingleFieldBuilderV3<Resource, Resource.Builder, ResourceOrBuilder> getTopicFieldBuilder() {
            if (this.topicBuilder_ == null) {
                this.topicBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getTopic(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.topic_ = null;
            }
            return this.topicBuilder_;
        }

        @Override
        public int getId() {
            return this.id_;
        }

        public Builder setId(int value) {
            this.id_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearId() {
            this.id_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getPermissionValue() {
            return this.permission_;
        }

        public Builder setPermissionValue(int value) {
            this.permission_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public Permission getPermission() {
            Permission result = Permission.valueOf(this.permission_);
            return result == null ? Permission.UNRECOGNIZED : result;
        }

        public Builder setPermission(Permission value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.permission_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearPermission() {
            this.permission_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasBroker() {
            return this.brokerBuilder_ != null || this.broker_ != null;
        }

        @Override
        public Broker getBroker() {
            if (this.brokerBuilder_ == null) {
                return this.broker_ == null ? Broker.getDefaultInstance() : this.broker_;
            }
            return (Broker)this.brokerBuilder_.getMessage();
        }

        public Builder setBroker(Broker value) {
            if (this.brokerBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.broker_ = value;
                this.onChanged();
            } else {
                this.brokerBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setBroker(Broker.Builder builderForValue) {
            if (this.brokerBuilder_ == null) {
                this.broker_ = builderForValue.build();
                this.onChanged();
            } else {
                this.brokerBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeBroker(Broker value) {
            if (this.brokerBuilder_ == null) {
                this.broker_ = this.broker_ != null ? Broker.newBuilder(this.broker_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.brokerBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearBroker() {
            if (this.brokerBuilder_ == null) {
                this.broker_ = null;
                this.onChanged();
            } else {
                this.broker_ = null;
                this.brokerBuilder_ = null;
            }
            return this;
        }

        public Broker.Builder getBrokerBuilder() {
            this.onChanged();
            return (Broker.Builder)this.getBrokerFieldBuilder().getBuilder();
        }

        @Override
        public BrokerOrBuilder getBrokerOrBuilder() {
            if (this.brokerBuilder_ != null) {
                return (BrokerOrBuilder)this.brokerBuilder_.getMessageOrBuilder();
            }
            return this.broker_ == null ? Broker.getDefaultInstance() : this.broker_;
        }

        private SingleFieldBuilderV3<Broker, Broker.Builder, BrokerOrBuilder> getBrokerFieldBuilder() {
            if (this.brokerBuilder_ == null) {
                this.brokerBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getBroker(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.broker_ = null;
            }
            return this.brokerBuilder_;
        }

        private void ensureAcceptMessageTypesIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.acceptMessageTypes_ = new ArrayList<Integer>(this.acceptMessageTypes_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<MessageType> getAcceptMessageTypesList() {
            return new Internal.ListAdapter(this.acceptMessageTypes_, acceptMessageTypes_converter_);
        }

        @Override
        public int getAcceptMessageTypesCount() {
            return this.acceptMessageTypes_.size();
        }

        @Override
        public MessageType getAcceptMessageTypes(int index) {
            return (MessageType)((Object)acceptMessageTypes_converter_.convert((Object)this.acceptMessageTypes_.get(index)));
        }

        public Builder setAcceptMessageTypes(int index, MessageType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAcceptMessageTypesIsMutable();
            this.acceptMessageTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAcceptMessageTypes(MessageType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAcceptMessageTypesIsMutable();
            this.acceptMessageTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllAcceptMessageTypes(Iterable<? extends MessageType> values) {
            this.ensureAcceptMessageTypesIsMutable();
            for (MessageType messageType : values) {
                this.acceptMessageTypes_.add(messageType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearAcceptMessageTypes() {
            this.acceptMessageTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getAcceptMessageTypesValueList() {
            return Collections.unmodifiableList(this.acceptMessageTypes_);
        }

        @Override
        public int getAcceptMessageTypesValue(int index) {
            return this.acceptMessageTypes_.get(index);
        }

        public Builder setAcceptMessageTypesValue(int index, int value) {
            this.ensureAcceptMessageTypesIsMutable();
            this.acceptMessageTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addAcceptMessageTypesValue(int value) {
            this.ensureAcceptMessageTypesIsMutable();
            this.acceptMessageTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllAcceptMessageTypesValue(Iterable<Integer> values) {
            this.ensureAcceptMessageTypesIsMutable();
            for (int value : values) {
                this.acceptMessageTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

