/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl.heartbeat;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.common.ControllerConfig;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.controller.BrokerHeartbeatManager;
import org.apache.rocketmq.controller.helper.BrokerLifecycleListener;
import org.apache.rocketmq.controller.impl.heartbeat.BrokerIdentityInfo;
import org.apache.rocketmq.controller.impl.heartbeat.BrokerLiveInfo;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;

public class DefaultBrokerHeartbeatManager
implements BrokerHeartbeatManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqController");
    private static final long DEFAULT_BROKER_CHANNEL_EXPIRED_TIME = 10000L;
    private ScheduledExecutorService scheduledService;
    private ExecutorService executor;
    private final ControllerConfig controllerConfig;
    private final Map<BrokerIdentityInfo, BrokerLiveInfo> brokerLiveTable;
    private final List<BrokerLifecycleListener> brokerLifecycleListeners;

    public DefaultBrokerHeartbeatManager(ControllerConfig controllerConfig) {
        this.controllerConfig = controllerConfig;
        this.brokerLiveTable = new ConcurrentHashMap<BrokerIdentityInfo, BrokerLiveInfo>(256);
        this.brokerLifecycleListeners = new ArrayList<BrokerLifecycleListener>();
    }

    @Override
    public void start() {
        this.scheduledService.scheduleAtFixedRate(this::scanNotActiveBroker, 2000L, this.controllerConfig.getScanNotActiveBrokerInterval(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        this.scheduledService.shutdown();
        this.executor.shutdown();
    }

    @Override
    public void initialize() {
        this.scheduledService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("DefaultBrokerHeartbeatManager_scheduledService_"));
        this.executor = Executors.newFixedThreadPool(2, (ThreadFactory)new ThreadFactoryImpl("DefaultBrokerHeartbeatManager_executorService_"));
    }

    public void scanNotActiveBroker() {
        try {
            log.info("start scanNotActiveBroker");
            Iterator<Map.Entry<BrokerIdentityInfo, BrokerLiveInfo>> iterator = this.brokerLiveTable.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<BrokerIdentityInfo, BrokerLiveInfo> next = iterator.next();
                long last = next.getValue().getLastUpdateTimestamp();
                long timeoutMillis = next.getValue().getHeartbeatTimeoutMillis();
                if (System.currentTimeMillis() - last <= timeoutMillis) continue;
                Channel channel = next.getValue().getChannel();
                iterator.remove();
                if (channel != null) {
                    RemotingHelper.closeChannel((Channel)channel);
                }
                this.executor.submit(() -> this.notifyBrokerInActive(((BrokerIdentityInfo)next.getKey()).getClusterName(), ((BrokerLiveInfo)next.getValue()).getBrokerName(), ((BrokerLiveInfo)next.getValue()).getBrokerId()));
                log.warn("The broker channel {} expired, brokerInfo {}, expired {}ms", new Object[]{next.getValue().getChannel(), next.getKey(), timeoutMillis});
            }
        }
        catch (Exception e) {
            log.error("scanNotActiveBroker exception", (Throwable)e);
        }
    }

    private void notifyBrokerInActive(String clusterName, String brokerName, Long brokerId) {
        for (BrokerLifecycleListener listener : this.brokerLifecycleListeners) {
            listener.onBrokerInactive(clusterName, brokerName, brokerId);
        }
    }

    @Override
    public void registerBrokerLifecycleListener(BrokerLifecycleListener listener) {
        this.brokerLifecycleListeners.add(listener);
    }

    @Override
    public void onBrokerHeartbeat(String clusterName, String brokerName, String brokerAddr, Long brokerId, Long timeoutMillis, Channel channel, Integer epoch, Long maxOffset, Long confirmOffset, Integer electionPriority) {
        BrokerIdentityInfo brokerIdentityInfo = new BrokerIdentityInfo(clusterName, brokerName, brokerId);
        BrokerLiveInfo prev = this.brokerLiveTable.get(brokerIdentityInfo);
        int realEpoch = Optional.ofNullable(epoch).orElse(-1);
        long realBrokerId = Optional.ofNullable(brokerId).orElse(-1L);
        long realMaxOffset = Optional.ofNullable(maxOffset).orElse(-1L);
        long realConfirmOffset = Optional.ofNullable(confirmOffset).orElse(-1L);
        long realTimeoutMillis = Optional.ofNullable(timeoutMillis).orElse(10000L);
        int realElectionPriority = Optional.ofNullable(electionPriority).orElse(Integer.MAX_VALUE);
        if (null == prev) {
            this.brokerLiveTable.put(brokerIdentityInfo, new BrokerLiveInfo(brokerName, brokerAddr, realBrokerId, System.currentTimeMillis(), realTimeoutMillis, channel, realEpoch, realMaxOffset, realElectionPriority));
            log.info("new broker registered, {}, brokerId:{}", (Object)brokerIdentityInfo, (Object)realBrokerId);
        } else {
            prev.setLastUpdateTimestamp(System.currentTimeMillis());
            prev.setHeartbeatTimeoutMillis(realTimeoutMillis);
            prev.setElectionPriority(realElectionPriority);
            if (realEpoch > prev.getEpoch() || realEpoch == prev.getEpoch() && realMaxOffset > prev.getMaxOffset()) {
                prev.setEpoch(realEpoch);
                prev.setMaxOffset(realMaxOffset);
                prev.setConfirmOffset(realConfirmOffset);
            }
        }
    }

    @Override
    public void onBrokerChannelClose(Channel channel) {
        BrokerIdentityInfo addrInfo = null;
        for (Map.Entry<BrokerIdentityInfo, BrokerLiveInfo> entry : this.brokerLiveTable.entrySet()) {
            if (entry.getValue().getChannel() != channel) continue;
            log.info("Channel {} inactive, broker {}, addr:{}, id:{}", new Object[]{entry.getValue().getChannel(), entry.getValue().getBrokerName(), entry.getValue().getBrokerAddr(), entry.getValue().getBrokerId()});
            addrInfo = entry.getKey();
            this.executor.submit(() -> this.notifyBrokerInActive(((BrokerIdentityInfo)entry.getKey()).getClusterName(), ((BrokerLiveInfo)entry.getValue()).getBrokerName(), ((BrokerLiveInfo)entry.getValue()).getBrokerId()));
            break;
        }
        if (addrInfo != null) {
            this.brokerLiveTable.remove(addrInfo);
        }
    }

    @Override
    public BrokerLiveInfo getBrokerLiveInfo(String clusterName, String brokerName, Long brokerId) {
        return this.brokerLiveTable.get(new BrokerIdentityInfo(clusterName, brokerName, brokerId));
    }

    @Override
    public boolean isBrokerActive(String clusterName, String brokerName, Long brokerId) {
        BrokerLiveInfo info = this.brokerLiveTable.get(new BrokerIdentityInfo(clusterName, brokerName, brokerId));
        if (info != null) {
            long timeoutMillis;
            long last = info.getLastUpdateTimestamp();
            return last + (timeoutMillis = info.getHeartbeatTimeoutMillis()) >= System.currentTimeMillis();
        }
        return false;
    }

    @Override
    public Map<String, Map<String, Integer>> getActiveBrokersNum() {
        HashMap<String, Map<String, Integer>> map = new HashMap<String, Map<String, Integer>>();
        this.brokerLiveTable.keySet().stream().filter(brokerIdentity -> this.isBrokerActive(brokerIdentity.getClusterName(), brokerIdentity.getBrokerName(), brokerIdentity.getBrokerId())).forEach(id -> {
            map.computeIfAbsent(id.getClusterName(), k -> new HashMap());
            ((Map)map.get(id.getClusterName())).compute(id.getBrokerName(), (broker, num) -> num == null ? 0 : num + 1);
        });
        return map;
    }
}

