/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.common;

import java.util.concurrent.atomic.LongAdder;
import org.apache.rocketmq.store.SelectMappedBufferResult;

public class SelectMappedBufferResultWrapper {
    private final SelectMappedBufferResult result;
    private final LongAdder accessCount;
    private final long curOffset;
    private final long minOffset;
    private final long maxOffset;
    private final long size;

    public SelectMappedBufferResultWrapper(SelectMappedBufferResult result, long curOffset, long minOffset, long maxOffset, long size) {
        this.result = result;
        this.accessCount = new LongAdder();
        this.curOffset = curOffset;
        this.minOffset = minOffset;
        this.maxOffset = maxOffset;
        this.size = size;
    }

    public SelectMappedBufferResult getResult() {
        return this.result;
    }

    public SelectMappedBufferResult getDuplicateResult() {
        return new SelectMappedBufferResult(this.result.getStartOffset(), this.result.getByteBuffer().asReadOnlyBuffer(), this.result.getSize(), this.result.getMappedFile());
    }

    public long getCurOffset() {
        return this.curOffset;
    }

    public long getMinOffset() {
        return this.minOffset;
    }

    public long getMaxOffset() {
        return this.maxOffset;
    }

    public long getSize() {
        return this.size;
    }

    public void addAccessCount() {
        this.accessCount.increment();
    }

    public long getAccessCount() {
        return this.accessCount.sum();
    }
}

