/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.route;

import com.google.common.base.MoreObjects;
import org.apache.rocketmq.proxy.service.route.MessageQueueSelector;
import org.apache.rocketmq.proxy.service.route.TopicRouteWrapper;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;

public class MessageQueueView {
    public static final MessageQueueView WRAPPED_EMPTY_QUEUE = new MessageQueueView("", new TopicRouteData());
    private final MessageQueueSelector readSelector;
    private final MessageQueueSelector writeSelector;
    private final TopicRouteWrapper topicRouteWrapper;

    public MessageQueueView(String topic, TopicRouteData topicRouteData) {
        this.topicRouteWrapper = new TopicRouteWrapper(topicRouteData, topic);
        this.readSelector = new MessageQueueSelector(this.topicRouteWrapper, true);
        this.writeSelector = new MessageQueueSelector(this.topicRouteWrapper, false);
    }

    public TopicRouteData getTopicRouteData() {
        return this.topicRouteWrapper.getTopicRouteData();
    }

    public TopicRouteWrapper getTopicRouteWrapper() {
        return this.topicRouteWrapper;
    }

    public String getTopicName() {
        return this.topicRouteWrapper.getTopicName();
    }

    public boolean isEmptyCachedQueue() {
        return this == WRAPPED_EMPTY_QUEUE;
    }

    public MessageQueueSelector getReadSelector() {
        return this.readSelector;
    }

    public MessageQueueSelector getWriteSelector() {
        return this.writeSelector;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("readSelector", (Object)this.readSelector).add("writeSelector", (Object)this.writeSelector).add("topicRouteWrapper", (Object)this.topicRouteWrapper).toString();
    }
}

