/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.impl.mqclient;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.client.ClientConfig;
import org.apache.rocketmq.client.consumer.AckCallback;
import org.apache.rocketmq.client.consumer.AckResult;
import org.apache.rocketmq.client.consumer.PopCallback;
import org.apache.rocketmq.client.consumer.PopResult;
import org.apache.rocketmq.client.consumer.PullCallback;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.consumer.PullStatus;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.exception.OffsetNotFoundException;
import org.apache.rocketmq.client.impl.ClientRemotingProcessor;
import org.apache.rocketmq.client.impl.CommunicationMode;
import org.apache.rocketmq.client.impl.MQClientAPIImpl;
import org.apache.rocketmq.client.impl.admin.MqClientAdminImpl;
import org.apache.rocketmq.client.impl.consumer.PullResultExt;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageBatch;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.ResponseFuture;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.body.LockBatchRequestBody;
import org.apache.rocketmq.remoting.protocol.body.LockBatchResponseBody;
import org.apache.rocketmq.remoting.protocol.body.UnlockBatchRequestBody;
import org.apache.rocketmq.remoting.protocol.header.AckMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ChangeInvisibleTimeRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ConsumerSendMsgBackRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerListByGroupRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerListByGroupResponseBody;
import org.apache.rocketmq.remoting.protocol.header.GetMaxOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetMaxOffsetResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.GetMinOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetMinOffsetResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.NotificationRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.NotificationResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.PopMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.PullMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryConsumerOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.QueryConsumerOffsetResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.SearchOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.SearchOffsetResponseHeader;
import org.apache.rocketmq.remoting.protocol.header.SendMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.SendMessageRequestHeaderV2;
import org.apache.rocketmq.remoting.protocol.header.UpdateConsumerOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.heartbeat.HeartbeatData;

public class MQClientAPIExt
extends MQClientAPIImpl {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final ClientConfig clientConfig;
    private final MqClientAdminImpl mqClientAdmin;

    public MQClientAPIExt(ClientConfig clientConfig, NettyClientConfig nettyClientConfig, ClientRemotingProcessor clientRemotingProcessor, RPCHook rpcHook) {
        super(nettyClientConfig, clientRemotingProcessor, rpcHook, clientConfig);
        this.clientConfig = clientConfig;
        this.mqClientAdmin = new MqClientAdminImpl(this.getRemotingClient());
    }

    public boolean updateNameServerAddressList() {
        if (this.clientConfig.getNamesrvAddr() != null) {
            this.updateNameServerAddressList(this.clientConfig.getNamesrvAddr());
            log.info("user specified name server address: {}", (Object)this.clientConfig.getNamesrvAddr());
            return true;
        }
        return false;
    }

    protected static MQClientException processNullResponseErr(ResponseFuture responseFuture) {
        MQClientException ex = !responseFuture.isSendRequestOK() ? new MQClientException("send request failed", responseFuture.getCause()) : (responseFuture.isTimeout() ? new MQClientException("wait response timeout " + responseFuture.getTimeoutMillis() + "ms", responseFuture.getCause()) : new MQClientException("unknown reason", responseFuture.getCause()));
        return ex;
    }

    public CompletableFuture<Void> sendHeartbeatOneway(String brokerAddr, HeartbeatData heartbeatData, long timeoutMillis) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RemotingCommand request = RemotingCommand.createRequestCommand((int)34, null);
            request.setLanguage(this.clientConfig.getLanguage());
            request.setBody(heartbeatData.encode());
            this.getRemotingClient().invokeOneway(brokerAddr, request, timeoutMillis);
            future.complete(null);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<Integer> sendHeartbeatAsync(String brokerAddr, HeartbeatData heartbeatData, long timeoutMillis) {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)34, null);
        request.setLanguage(this.clientConfig.getLanguage());
        request.setBody(heartbeatData.encode());
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        try {
            this.getRemotingClient().invokeAsync(brokerAddr, request, timeoutMillis, responseFuture -> {
                RemotingCommand response = responseFuture.getResponseCommand();
                if (response != null) {
                    if (0 == response.getCode()) {
                        future.complete(response.getVersion());
                    } else {
                        future.completeExceptionally(new MQBrokerException(response.getCode(), response.getRemark(), brokerAddr));
                    }
                } else {
                    future.completeExceptionally(MQClientAPIExt.processNullResponseErr(responseFuture));
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<SendResult> sendMessageAsync(String brokerAddr, String brokerName, Message msg, SendMessageRequestHeader requestHeader, long timeoutMillis) {
        SendMessageRequestHeaderV2 requestHeaderV2 = SendMessageRequestHeaderV2.createSendMessageRequestHeaderV2((SendMessageRequestHeader)requestHeader);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)310, (CommandCustomHeader)requestHeaderV2);
        request.setBody(msg.getBody());
        CompletableFuture<SendResult> future = new CompletableFuture<SendResult>();
        try {
            this.getRemotingClient().invokeAsync(brokerAddr, request, timeoutMillis, responseFuture -> {
                RemotingCommand response = responseFuture.getResponseCommand();
                if (response != null) {
                    try {
                        future.complete(this.processSendResponse(brokerName, msg, response, brokerAddr));
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                    }
                } else {
                    future.completeExceptionally(MQClientAPIExt.processNullResponseErr(responseFuture));
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<SendResult> sendMessageAsync(String brokerAddr, String brokerName, List<? extends Message> msgList, SendMessageRequestHeader requestHeader, long timeoutMillis) {
        SendMessageRequestHeaderV2 requestHeaderV2 = SendMessageRequestHeaderV2.createSendMessageRequestHeaderV2((SendMessageRequestHeader)requestHeader);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)320, (CommandCustomHeader)requestHeaderV2);
        CompletableFuture<SendResult> future = new CompletableFuture<SendResult>();
        try {
            requestHeader.setBatch(true);
            MessageBatch msgBatch = MessageBatch.generateFromList(msgList);
            MessageClientIDSetter.setUniqID((Message)msgBatch);
            byte[] body = msgBatch.encode();
            msgBatch.setBody(body);
            request.setBody(body);
            this.getRemotingClient().invokeAsync(brokerAddr, request, timeoutMillis, responseFuture -> {
                RemotingCommand response = responseFuture.getResponseCommand();
                if (response != null) {
                    try {
                        future.complete(this.processSendResponse(brokerName, (Message)msgBatch, response, brokerAddr));
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                    }
                } else {
                    future.completeExceptionally(MQClientAPIExt.processNullResponseErr(responseFuture));
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<RemotingCommand> sendMessageBackAsync(String brokerAddr, ConsumerSendMsgBackRequestHeader requestHeader, long timeoutMillis) {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)36, (CommandCustomHeader)requestHeader);
        CompletableFuture<RemotingCommand> future = new CompletableFuture<RemotingCommand>();
        try {
            this.getRemotingClient().invokeAsync(brokerAddr, request, timeoutMillis, responseFuture -> {
                RemotingCommand response = responseFuture.getResponseCommand();
                if (response != null) {
                    future.complete(response);
                } else {
                    future.completeExceptionally(MQClientAPIExt.processNullResponseErr(responseFuture));
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<PopResult> popMessageAsync(String brokerAddr, String brokerName, PopMessageRequestHeader requestHeader, long timeoutMillis) {
        final CompletableFuture<PopResult> future = new CompletableFuture<PopResult>();
        try {
            this.popMessageAsync(brokerName, brokerAddr, requestHeader, timeoutMillis, new PopCallback(){

                @Override
                public void onSuccess(PopResult popResult) {
                    future.complete(popResult);
                }

                @Override
                public void onException(Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<AckResult> ackMessageAsync(String brokerAddr, AckMessageRequestHeader requestHeader, long timeoutMillis) {
        final CompletableFuture<AckResult> future = new CompletableFuture<AckResult>();
        try {
            this.ackMessageAsync(brokerAddr, timeoutMillis, new AckCallback(){

                @Override
                public void onSuccess(AckResult ackResult) {
                    future.complete(ackResult);
                }

                @Override
                public void onException(Throwable t) {
                    future.completeExceptionally(t);
                }
            }, requestHeader);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<AckResult> batchAckMessageAsync(String brokerAddr, String topic, String consumerGroup, List<String> extraInfoList, long timeoutMillis) {
        final CompletableFuture<AckResult> future = new CompletableFuture<AckResult>();
        try {
            this.batchAckMessageAsync(brokerAddr, timeoutMillis, new AckCallback(){

                @Override
                public void onSuccess(AckResult ackResult) {
                    future.complete(ackResult);
                }

                @Override
                public void onException(Throwable t) {
                    future.completeExceptionally(t);
                }
            }, topic, consumerGroup, extraInfoList);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<AckResult> changeInvisibleTimeAsync(String brokerAddr, String brokerName, ChangeInvisibleTimeRequestHeader requestHeader, long timeoutMillis) {
        final CompletableFuture<AckResult> future = new CompletableFuture<AckResult>();
        try {
            this.changeInvisibleTimeAsync(brokerName, brokerAddr, requestHeader, timeoutMillis, new AckCallback(){

                @Override
                public void onSuccess(AckResult ackResult) {
                    future.complete(ackResult);
                }

                @Override
                public void onException(Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<PullResult> pullMessageAsync(String brokerAddr, PullMessageRequestHeader requestHeader, long timeoutMillis) {
        final CompletableFuture<PullResult> future = new CompletableFuture<PullResult>();
        try {
            this.pullMessage(brokerAddr, requestHeader, timeoutMillis, CommunicationMode.ASYNC, new PullCallback(){

                @Override
                public void onSuccess(PullResult pullResult) {
                    if (pullResult instanceof PullResultExt) {
                        PullResultExt pullResultExt = (PullResultExt)pullResult;
                        if (PullStatus.FOUND.equals((Object)pullResult.getPullStatus())) {
                            List messageExtList = MessageDecoder.decodesBatch((ByteBuffer)ByteBuffer.wrap(pullResultExt.getMessageBinary()), (boolean)true, (boolean)false, (boolean)true);
                            pullResult.setMsgFoundList(messageExtList);
                        }
                    }
                    future.complete(pullResult);
                }

                @Override
                public void onException(Throwable t) {
                    future.completeExceptionally(t);
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<Long> queryConsumerOffsetWithFuture(String brokerAddr, QueryConsumerOffsetRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        try {
            RemotingCommand request = RemotingCommand.createRequestCommand((int)14, (CommandCustomHeader)requestHeader);
            this.getRemotingClient().invokeAsync(brokerAddr, request, timeoutMillis, responseFuture -> {
                RemotingCommand response = responseFuture.getResponseCommand();
                if (response != null) {
                    switch (response.getCode()) {
                        case 0: {
                            try {
                                QueryConsumerOffsetResponseHeader responseHeader = (QueryConsumerOffsetResponseHeader)response.decodeCommandCustomHeader(QueryConsumerOffsetResponseHeader.class);
                                future.complete(responseHeader.getOffset());
                            }
                            catch (RemotingCommandException e) {
                                future.completeExceptionally(e);
                            }
                            break;
                        }
                        case 22: {
                            future.completeExceptionally(new OffsetNotFoundException(response.getCode(), response.getRemark(), brokerAddr));
                            break;
                        }
                    }
                } else {
                    future.completeExceptionally(MQClientAPIExt.processNullResponseErr(responseFuture));
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<Void> updateConsumerOffsetOneWay(String brokerAddr, UpdateConsumerOffsetRequestHeader header, long timeoutMillis) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            RemotingCommand request = RemotingCommand.createRequestCommand((int)15, (CommandCustomHeader)header);
            this.getRemotingClient().invokeOneway(brokerAddr, request, timeoutMillis);
            future.complete(null);
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<List<String>> getConsumerListByGroupAsync(String brokerAddr, GetConsumerListByGroupRequestHeader requestHeader, long timeoutMillis) {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)38, (CommandCustomHeader)requestHeader);
        CompletableFuture<List<String>> future = new CompletableFuture<List<String>>();
        try {
            this.getRemotingClient().invokeAsync(brokerAddr, request, timeoutMillis, responseFuture -> {
                RemotingCommand response = responseFuture.getResponseCommand();
                if (response != null) {
                    switch (response.getCode()) {
                        case 0: {
                            if (response.getBody() != null) {
                                GetConsumerListByGroupResponseBody body = (GetConsumerListByGroupResponseBody)GetConsumerListByGroupResponseBody.decode((byte[])response.getBody(), GetConsumerListByGroupResponseBody.class);
                                future.complete(body.getConsumerIdList());
                                return;
                            }
                        }
                        case 1: {
                            future.complete(Collections.emptyList());
                            return;
                        }
                    }
                    future.completeExceptionally(new MQBrokerException(response.getCode(), response.getRemark()));
                } else {
                    future.completeExceptionally(MQClientAPIExt.processNullResponseErr(responseFuture));
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<Long> getMaxOffset(String brokerAddr, GetMaxOffsetRequestHeader requestHeader, long timeoutMillis) {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)30, (CommandCustomHeader)requestHeader);
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        try {
            this.getRemotingClient().invokeAsync(brokerAddr, request, timeoutMillis, responseFuture -> {
                RemotingCommand response = responseFuture.getResponseCommand();
                if (response != null) {
                    if (0 == response.getCode()) {
                        try {
                            GetMaxOffsetResponseHeader responseHeader = (GetMaxOffsetResponseHeader)response.decodeCommandCustomHeader(GetMaxOffsetResponseHeader.class);
                            future.complete(responseHeader.getOffset());
                        }
                        catch (Throwable t) {
                            future.completeExceptionally(t);
                        }
                    }
                    future.completeExceptionally(new MQBrokerException(response.getCode(), response.getRemark()));
                } else {
                    future.completeExceptionally(MQClientAPIExt.processNullResponseErr(responseFuture));
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<Long> getMinOffset(String brokerAddr, GetMinOffsetRequestHeader requestHeader, long timeoutMillis) {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)31, (CommandCustomHeader)requestHeader);
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        try {
            this.getRemotingClient().invokeAsync(brokerAddr, request, timeoutMillis, responseFuture -> {
                RemotingCommand response = responseFuture.getResponseCommand();
                if (response != null) {
                    if (0 == response.getCode()) {
                        try {
                            GetMinOffsetResponseHeader responseHeader = (GetMinOffsetResponseHeader)response.decodeCommandCustomHeader(GetMinOffsetResponseHeader.class);
                            future.complete(responseHeader.getOffset());
                        }
                        catch (Throwable t) {
                            future.completeExceptionally(t);
                        }
                    }
                    future.completeExceptionally(new MQBrokerException(response.getCode(), response.getRemark()));
                } else {
                    future.completeExceptionally(MQClientAPIExt.processNullResponseErr(responseFuture));
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<Long> searchOffset(String brokerAddr, SearchOffsetRequestHeader requestHeader, long timeoutMillis) {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)29, (CommandCustomHeader)requestHeader);
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        try {
            this.getRemotingClient().invokeAsync(brokerAddr, request, timeoutMillis, responseFuture -> {
                RemotingCommand response = responseFuture.getResponseCommand();
                if (response != null) {
                    if (response.getCode() == 0) {
                        try {
                            SearchOffsetResponseHeader responseHeader = (SearchOffsetResponseHeader)response.decodeCommandCustomHeader(SearchOffsetResponseHeader.class);
                            future.complete(responseHeader.getOffset());
                        }
                        catch (Throwable t) {
                            future.completeExceptionally(t);
                        }
                    }
                    future.completeExceptionally(new MQBrokerException(response.getCode(), response.getRemark()));
                } else {
                    future.completeExceptionally(MQClientAPIExt.processNullResponseErr(responseFuture));
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<Set<MessageQueue>> lockBatchMQWithFuture(String brokerAddr, LockBatchRequestBody requestBody, long timeoutMillis) {
        CompletableFuture<Set<MessageQueue>> future = new CompletableFuture<Set<MessageQueue>>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)41, null);
        request.setBody(requestBody.encode());
        try {
            this.getRemotingClient().invokeAsync(brokerAddr, request, timeoutMillis, responseFuture -> {
                RemotingCommand response = responseFuture.getResponseCommand();
                if (response != null) {
                    if (response.getCode() == 0) {
                        try {
                            LockBatchResponseBody responseBody = (LockBatchResponseBody)LockBatchResponseBody.decode((byte[])response.getBody(), LockBatchResponseBody.class);
                            Set messageQueues = responseBody.getLockOKMQSet();
                            future.complete(messageQueues);
                        }
                        catch (Throwable t) {
                            future.completeExceptionally(t);
                        }
                    }
                    future.completeExceptionally(new MQBrokerException(response.getCode(), response.getRemark()));
                } else {
                    future.completeExceptionally(MQClientAPIExt.processNullResponseErr(responseFuture));
                }
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public CompletableFuture<Void> unlockBatchMQOneway(String brokerAddr, UnlockBatchRequestBody requestBody, long timeoutMillis) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)42, null);
        request.setBody(requestBody.encode());
        try {
            this.getRemotingClient().invokeOneway(brokerAddr, request, timeoutMillis);
            future.complete(null);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public CompletableFuture<Boolean> notification(String brokerAddr, NotificationRequestHeader requestHeader, long timeoutMillis) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        RemotingCommand request = RemotingCommand.createRequestCommand((int)200054, (CommandCustomHeader)requestHeader);
        try {
            this.getRemotingClient().invoke(brokerAddr, request, timeoutMillis).thenAccept(response -> {
                if (response.getCode() == 0) {
                    try {
                        NotificationResponseHeader responseHeader = (NotificationResponseHeader)response.decodeCommandCustomHeader(NotificationResponseHeader.class);
                        future.complete(responseHeader.isHasMsg());
                    }
                    catch (Throwable t) {
                        future.completeExceptionally(t);
                    }
                } else {
                    future.completeExceptionally(new MQBrokerException(response.getCode(), response.getRemark()));
                }
            });
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<RemotingCommand> invoke(String brokerAddr, RemotingCommand request, long timeoutMillis) {
        return this.getRemotingClient().invoke(brokerAddr, request, timeoutMillis);
    }

    public CompletableFuture<Void> invokeOneway(String brokerAddr, RemotingCommand request, long timeoutMillis) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.getRemotingClient().invokeOneway(brokerAddr, request, timeoutMillis);
            future.complete(null);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public MqClientAdminImpl getMqClientAdmin() {
        return this.mqClientAdmin;
    }
}

