/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.producer;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageBatch;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.exception.RemotingException;

public class ProduceAccumulator {
    private long totalHoldSize = 0x2000000L;
    private long holdSize = 32768L;
    private int holdMs = 10;
    private final Logger log = LoggerFactory.getLogger(DefaultMQProducer.class);
    private final GuardForSyncSendService guardThreadForSyncSend;
    private final GuardForAsyncSendService guardThreadForAsyncSend;
    private Map<AggregateKey, MessageAccumulation> syncSendBatchs = new ConcurrentHashMap<AggregateKey, MessageAccumulation>();
    private Map<AggregateKey, MessageAccumulation> asyncSendBatchs = new ConcurrentHashMap<AggregateKey, MessageAccumulation>();
    private AtomicLong currentlyHoldSize = new AtomicLong(0L);
    private final String instanceName;

    public ProduceAccumulator(String instanceName) {
        this.instanceName = instanceName;
        this.guardThreadForSyncSend = new GuardForSyncSendService(this.instanceName);
        this.guardThreadForAsyncSend = new GuardForAsyncSendService(this.instanceName);
    }

    void start() {
        this.guardThreadForSyncSend.start();
        this.guardThreadForAsyncSend.start();
    }

    void shutdown() {
        this.guardThreadForSyncSend.shutdown();
        this.guardThreadForAsyncSend.shutdown();
    }

    int getBatchMaxDelayMs() {
        return this.holdMs;
    }

    void batchMaxDelayMs(int holdMs) {
        if (holdMs <= 0 || holdMs > 30000) {
            throw new IllegalArgumentException(String.format("batchMaxDelayMs expect between 1ms and 30s, but get %d!", holdMs));
        }
        this.holdMs = holdMs;
    }

    long getBatchMaxBytes() {
        return this.holdSize;
    }

    void batchMaxBytes(long holdSize) {
        if (holdSize <= 0L || holdSize > 0x200000L) {
            throw new IllegalArgumentException(String.format("batchMaxBytes expect between 1B and 2MB, but get %d!", holdSize));
        }
        this.holdSize = holdSize;
    }

    long getTotalBatchMaxBytes() {
        return this.holdSize;
    }

    void totalBatchMaxBytes(long totalHoldSize) {
        if (totalHoldSize <= 0L) {
            throw new IllegalArgumentException(String.format("totalBatchMaxBytes must bigger then 0, but get %d!", totalHoldSize));
        }
        this.totalHoldSize = totalHoldSize;
    }

    private MessageAccumulation getOrCreateSyncSendBatch(AggregateKey aggregateKey, DefaultMQProducer defaultMQProducer) {
        MessageAccumulation batch = this.syncSendBatchs.get(aggregateKey);
        if (batch != null) {
            return batch;
        }
        batch = new MessageAccumulation(aggregateKey, defaultMQProducer);
        MessageAccumulation previous = this.syncSendBatchs.putIfAbsent(aggregateKey, batch);
        return previous == null ? batch : previous;
    }

    private MessageAccumulation getOrCreateAsyncSendBatch(AggregateKey aggregateKey, DefaultMQProducer defaultMQProducer) {
        MessageAccumulation batch = this.asyncSendBatchs.get(aggregateKey);
        if (batch != null) {
            return batch;
        }
        batch = new MessageAccumulation(aggregateKey, defaultMQProducer);
        MessageAccumulation previous = this.asyncSendBatchs.putIfAbsent(aggregateKey, batch);
        return previous == null ? batch : previous;
    }

    SendResult send(Message msg, DefaultMQProducer defaultMQProducer) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        MessageAccumulation batch;
        int index;
        AggregateKey partitionKey = new AggregateKey(msg);
        while ((index = (batch = this.getOrCreateSyncSendBatch(partitionKey, defaultMQProducer)).add(msg)) == -1) {
            this.syncSendBatchs.remove(partitionKey, batch);
        }
        return batch.sendResults[index];
    }

    SendResult send(Message msg, MessageQueue mq, DefaultMQProducer defaultMQProducer) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        MessageAccumulation batch;
        int index;
        AggregateKey partitionKey = new AggregateKey(msg, mq);
        while ((index = (batch = this.getOrCreateSyncSendBatch(partitionKey, defaultMQProducer)).add(msg)) == -1) {
            this.syncSendBatchs.remove(partitionKey, batch);
        }
        return batch.sendResults[index];
    }

    void send(Message msg, SendCallback sendCallback, DefaultMQProducer defaultMQProducer) throws InterruptedException, RemotingException, MQClientException {
        MessageAccumulation batch;
        AggregateKey partitionKey = new AggregateKey(msg);
        while (!(batch = this.getOrCreateAsyncSendBatch(partitionKey, defaultMQProducer)).add(msg, sendCallback)) {
            this.asyncSendBatchs.remove(partitionKey, batch);
        }
    }

    void send(Message msg, MessageQueue mq, SendCallback sendCallback, DefaultMQProducer defaultMQProducer) throws InterruptedException, RemotingException, MQClientException {
        MessageAccumulation batch;
        AggregateKey partitionKey = new AggregateKey(msg, mq);
        while (!(batch = this.getOrCreateAsyncSendBatch(partitionKey, defaultMQProducer)).add(msg, sendCallback)) {
            this.asyncSendBatchs.remove(partitionKey, batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryAddMessage(Message message) {
        AtomicLong atomicLong = this.currentlyHoldSize;
        synchronized (atomicLong) {
            if (this.currentlyHoldSize.get() < this.totalHoldSize) {
                this.currentlyHoldSize.addAndGet(message.getBody().length);
                return true;
            }
            return false;
        }
    }

    private class MessageAccumulation {
        private final DefaultMQProducer defaultMQProducer;
        private LinkedList<Message> messages;
        private LinkedList<SendCallback> sendCallbacks;
        private Set<String> keys;
        private AtomicBoolean closed;
        private SendResult[] sendResults;
        private AggregateKey aggregateKey;
        private AtomicInteger messagesSize;
        private int count;
        private long createTime;

        public MessageAccumulation(AggregateKey aggregateKey, DefaultMQProducer defaultMQProducer) {
            this.defaultMQProducer = defaultMQProducer;
            this.messages = new LinkedList();
            this.sendCallbacks = new LinkedList();
            this.keys = new HashSet<String>();
            this.closed = new AtomicBoolean(false);
            this.messagesSize = new AtomicInteger(0);
            this.aggregateKey = aggregateKey;
            this.count = 0;
            this.createTime = System.currentTimeMillis();
        }

        private boolean readyToSend() {
            return (long)this.messagesSize.get() > ProduceAccumulator.this.holdSize || System.currentTimeMillis() >= this.createTime + (long)ProduceAccumulator.this.holdMs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int add(Message msg) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
            int ret = -1;
            Object object = this.closed;
            synchronized (object) {
                if (this.closed.get()) {
                    return ret;
                }
                ret = this.count++;
                this.messages.add(msg);
                this.messagesSize.addAndGet(msg.getBody().length);
                String msgKeys = msg.getKeys();
                if (msgKeys != null) {
                    this.keys.addAll(Arrays.asList(msgKeys.split(" ")));
                }
            }
            object = this;
            synchronized (object) {
                while (!this.closed.get()) {
                    if (this.readyToSend()) {
                        this.send();
                        break;
                    }
                    this.wait();
                }
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(Message msg, SendCallback sendCallback) throws InterruptedException, RemotingException, MQClientException {
            AtomicBoolean atomicBoolean = this.closed;
            synchronized (atomicBoolean) {
                if (this.closed.get()) {
                    return false;
                }
                ++this.count;
                this.messages.add(msg);
                this.sendCallbacks.add(sendCallback);
                this.messagesSize.getAndAdd(msg.getBody().length);
            }
            if (this.readyToSend()) {
                this.send(sendCallback);
            }
            return true;
        }

        public synchronized void wakeup() {
            if (this.closed.get()) {
                return;
            }
            this.notify();
        }

        private MessageBatch batch() {
            MessageBatch messageBatch = new MessageBatch(this.messages);
            messageBatch.setTopic(this.aggregateKey.topic);
            messageBatch.setWaitStoreMsgOK(this.aggregateKey.waitStoreMsgOK);
            messageBatch.setKeys(this.keys);
            messageBatch.setTags(this.aggregateKey.tag);
            MessageClientIDSetter.setUniqID((Message)messageBatch);
            messageBatch.setBody(MessageDecoder.encodeMessages(this.messages));
            return messageBatch;
        }

        private void splitSendResults(SendResult sendResult) {
            if (sendResult == null) {
                throw new IllegalArgumentException("sendResult is null");
            }
            boolean isBatchConsumerQueue = !sendResult.getMsgId().contains(",");
            this.sendResults = new SendResult[this.count];
            if (!isBatchConsumerQueue) {
                String[] msgIds = sendResult.getMsgId().split(",");
                String[] offsetMsgIds = sendResult.getOffsetMsgId().split(",");
                if (offsetMsgIds.length != this.count || msgIds.length != this.count) {
                    throw new IllegalArgumentException("sendResult is illegal");
                }
                for (int i = 0; i < this.count; ++i) {
                    this.sendResults[i] = new SendResult(sendResult.getSendStatus(), msgIds[i], sendResult.getMessageQueue(), sendResult.getQueueOffset() + (long)i, sendResult.getTransactionId(), offsetMsgIds[i], sendResult.getRegionId());
                }
            } else {
                for (int i = 0; i < this.count; ++i) {
                    this.sendResults[i] = sendResult;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void send() throws InterruptedException, MQClientException, MQBrokerException, RemotingException {
            block8: {
                AtomicBoolean atomicBoolean = this.closed;
                synchronized (atomicBoolean) {
                    if (this.closed.getAndSet(true)) {
                        return;
                    }
                }
                MessageBatch messageBatch = this.batch();
                SendResult sendResult = null;
                try {
                    if (this.defaultMQProducer != null) {
                        sendResult = this.defaultMQProducer.sendDirect((Message)messageBatch, this.aggregateKey.mq, null);
                        this.splitSendResults(sendResult);
                        break block8;
                    }
                    throw new IllegalArgumentException("defaultMQProducer is null, can not send message");
                }
                finally {
                    ProduceAccumulator.this.currentlyHoldSize.addAndGet(-this.messagesSize.get());
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void send(SendCallback sendCallback) {
            AtomicBoolean atomicBoolean = this.closed;
            synchronized (atomicBoolean) {
                if (this.closed.getAndSet(true)) {
                    return;
                }
            }
            MessageBatch messageBatch = this.batch();
            Object sendResult = null;
            try {
                if (this.defaultMQProducer == null) {
                    throw new IllegalArgumentException("defaultMQProducer is null, can not send message");
                }
                final int size = this.messagesSize.get();
                this.defaultMQProducer.sendDirect((Message)messageBatch, this.aggregateKey.mq, new SendCallback(){

                    @Override
                    public void onSuccess(SendResult sendResult) {
                        try {
                            MessageAccumulation.this.splitSendResults(sendResult);
                            int i = 0;
                            for (SendCallback v : MessageAccumulation.this.sendCallbacks) {
                                v.onSuccess(MessageAccumulation.this.sendResults[i++]);
                            }
                            if (i != MessageAccumulation.this.count) {
                                throw new IllegalArgumentException("sendResult is illegal");
                            }
                            ProduceAccumulator.this.currentlyHoldSize.addAndGet(-size);
                        }
                        catch (Exception e) {
                            this.onException(e);
                        }
                    }

                    @Override
                    public void onException(Throwable e) {
                        for (SendCallback v : MessageAccumulation.this.sendCallbacks) {
                            v.onException(e);
                        }
                        ProduceAccumulator.this.currentlyHoldSize.addAndGet(-size);
                    }
                });
            }
            catch (Exception e) {
                for (SendCallback v : this.sendCallbacks) {
                    v.onException(e);
                }
            }
        }
    }

    private class AggregateKey {
        public String topic = null;
        public MessageQueue mq = null;
        public boolean waitStoreMsgOK = false;
        public String tag = null;

        public AggregateKey(Message message) {
            this(message.getTopic(), null, message.isWaitStoreMsgOK(), message.getTags());
        }

        public AggregateKey(Message message, MessageQueue mq) {
            this(message.getTopic(), mq, message.isWaitStoreMsgOK(), message.getTags());
        }

        public AggregateKey(String topic, MessageQueue mq, boolean waitStoreMsgOK, String tag) {
            this.topic = topic;
            this.mq = mq;
            this.waitStoreMsgOK = waitStoreMsgOK;
            this.tag = tag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AggregateKey key = (AggregateKey)o;
            return this.waitStoreMsgOK == key.waitStoreMsgOK && this.topic.equals(key.topic) && Objects.equals(this.mq, key.mq) && Objects.equals(this.tag, key.tag);
        }

        public int hashCode() {
            return Objects.hash(this.topic, this.mq, this.waitStoreMsgOK, this.tag);
        }
    }

    private class GuardForAsyncSendService
    extends ServiceThread {
        private final String serviceName;

        public GuardForAsyncSendService(String clientInstanceName) {
            this.serviceName = String.format("Client_%s_GuardForAsyncSend", clientInstanceName);
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void run() {
            ProduceAccumulator.this.log.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                try {
                    this.doWork();
                }
                catch (Exception e) {
                    ProduceAccumulator.this.log.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
                }
            }
            ProduceAccumulator.this.log.info(this.getServiceName() + " service end");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doWork() throws Exception {
            Collection values = ProduceAccumulator.this.asyncSendBatchs.values();
            int sleepTime = Math.max(1, ProduceAccumulator.this.holdMs / 2);
            for (MessageAccumulation v : values) {
                if (v.readyToSend()) {
                    v.send(null);
                }
                AtomicBoolean atomicBoolean = v.closed;
                synchronized (atomicBoolean) {
                    if (v.messagesSize.get() == 0) {
                        v.closed.set(true);
                        ProduceAccumulator.this.asyncSendBatchs.remove(v.aggregateKey, v);
                    }
                }
            }
            Thread.sleep(sleepTime);
        }
    }

    private class GuardForSyncSendService
    extends ServiceThread {
        private final String serviceName;

        public GuardForSyncSendService(String clientInstanceName) {
            this.serviceName = String.format("Client_%s_GuardForSyncSend", clientInstanceName);
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void run() {
            ProduceAccumulator.this.log.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                try {
                    this.doWork();
                }
                catch (Exception e) {
                    ProduceAccumulator.this.log.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
                }
            }
            ProduceAccumulator.this.log.info(this.getServiceName() + " service end");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doWork() throws InterruptedException {
            Collection values = ProduceAccumulator.this.syncSendBatchs.values();
            int sleepTime = Math.max(1, ProduceAccumulator.this.holdMs / 2);
            for (MessageAccumulation v : values) {
                v.wakeup();
                MessageAccumulation messageAccumulation = v;
                synchronized (messageAccumulation) {
                    AtomicBoolean atomicBoolean = v.closed;
                    synchronized (atomicBoolean) {
                        if (v.messagesSize.get() == 0) {
                            v.closed.set(true);
                            ProduceAccumulator.this.syncSendBatchs.remove(v.aggregateKey, v);
                        } else {
                            v.notify();
                        }
                    }
                }
            }
            Thread.sleep(sleepTime);
        }
    }
}

