/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.v2.common;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class ResponseWriter {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    protected static final Object INSTANCE_CREATE_LOCK = new Object();
    protected static volatile ResponseWriter instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseWriter getInstance() {
        if (instance == null) {
            Object object = INSTANCE_CREATE_LOCK;
            synchronized (object) {
                if (instance == null) {
                    instance = new ResponseWriter();
                }
            }
        }
        return instance;
    }

    public <T> void write(StreamObserver<T> observer, T response) {
        if (this.writeResponse(observer, response)) {
            observer.onCompleted();
        }
    }

    public <T> boolean writeResponse(StreamObserver<T> observer, T response) {
        if (null == response) {
            return false;
        }
        log.debug("start to write response. response: {}", response);
        if (this.isCancelled(observer)) {
            log.warn("client has cancelled the request. response to write: {}", response);
            return false;
        }
        try {
            observer.onNext(response);
        }
        catch (StatusRuntimeException statusRuntimeException) {
            if (Status.CANCELLED.equals((Object)statusRuntimeException.getStatus())) {
                log.warn("client has cancelled the request. response to write: {}", response);
                return false;
            }
            throw statusRuntimeException;
        }
        return true;
    }

    public <T> boolean isCancelled(StreamObserver<T> observer) {
        if (observer instanceof ServerCallStreamObserver) {
            ServerCallStreamObserver serverCallStreamObserver = (ServerCallStreamObserver)observer;
            return serverCallStreamObserver.isCancelled();
        }
        return false;
    }
}

