/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting.protocol.http2proxy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.haproxy.HAProxyCommand;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.netty.handler.codec.haproxy.HAProxyTLV;
import io.netty.util.Attribute;
import io.netty.util.DefaultAttributeMap;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.rocketmq.acl.common.AclUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.netty.AttributeKeys;

public class HAProxyMessageForwarder
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqRemoting");
    private static final Field FIELD_ATTRIBUTE = FieldUtils.getField(DefaultAttributeMap.class, (String)"attributes", (boolean)true);
    private final Channel outboundChannel;

    public HAProxyMessageForwarder(Channel outboundChannel) {
        this.outboundChannel = outboundChannel;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            this.forwardHAProxyMessage(ctx.channel(), this.outboundChannel);
            ctx.fireChannelRead(msg);
        }
        catch (Exception e) {
            log.error("Forward HAProxyMessage from Remoting to gRPC server error.", (Throwable)e);
            throw e;
        }
        finally {
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    private void forwardHAProxyMessage(Channel inboundChannel, Channel outboundChannel) throws Exception {
        if (!inboundChannel.hasAttr(AttributeKeys.PROXY_PROTOCOL_ADDR)) {
            return;
        }
        if (!(inboundChannel instanceof DefaultAttributeMap)) {
            return;
        }
        Object[] attributes = (Attribute[])FieldUtils.readField((Field)FIELD_ATTRIBUTE, (Object)inboundChannel);
        if (ArrayUtils.isEmpty((Object[])attributes)) {
            return;
        }
        String sourceAddress = null;
        String destinationAddress = null;
        int sourcePort = 0;
        int destinationPort = 0;
        ArrayList<HAProxyTLV> haProxyTLVs = new ArrayList<HAProxyTLV>();
        for (Object attribute : attributes) {
            String attributeValue;
            String attributeKey = attribute.key().name();
            if (!StringUtils.startsWith((CharSequence)attributeKey, (CharSequence)"proxy_protocol_") || StringUtils.isEmpty((CharSequence)(attributeValue = (String)attribute.get()))) continue;
            if (attribute.key() == AttributeKeys.PROXY_PROTOCOL_ADDR) {
                sourceAddress = attributeValue;
            }
            if (attribute.key() == AttributeKeys.PROXY_PROTOCOL_PORT) {
                sourcePort = Integer.parseInt(attributeValue);
            }
            if (attribute.key() == AttributeKeys.PROXY_PROTOCOL_SERVER_ADDR) {
                destinationAddress = attributeValue;
            }
            if (attribute.key() == AttributeKeys.PROXY_PROTOCOL_SERVER_PORT) {
                destinationPort = Integer.parseInt(attributeValue);
            }
            if (!StringUtils.startsWith((CharSequence)attributeKey, (CharSequence)"proxy_protocol_tlv_0x")) continue;
            String typeString = StringUtils.substringAfter((String)attributeKey, (String)"proxy_protocol_tlv_0x");
            ByteBuf byteBuf = Unpooled.buffer();
            byteBuf.writeBytes(attributeValue.getBytes(Charset.defaultCharset()));
            HAProxyTLV haProxyTLV = new HAProxyTLV(Hex.decodeHex((String)typeString)[0], byteBuf);
            haProxyTLVs.add(haProxyTLV);
        }
        HAProxyProxiedProtocol proxiedProtocol = AclUtils.isColon(sourceAddress) ? HAProxyProxiedProtocol.TCP6 : HAProxyProxiedProtocol.TCP4;
        HAProxyMessage message = new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, proxiedProtocol, sourceAddress, destinationAddress, sourcePort, destinationPort, haProxyTLVs);
        outboundChannel.writeAndFlush((Object)message).sync();
    }
}

