/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.tieredstore.util.CQItemBufferUtil;

public class MessageBufferUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    public static final int QUEUE_OFFSET_POSITION = 20;
    public static final int PHYSICAL_OFFSET_POSITION = 28;
    public static final int SYS_FLAG_OFFSET_POSITION = 36;
    public static final int STORE_TIMESTAMP_POSITION = 56;
    public static final int STORE_HOST_POSITION = 64;

    public static int getTotalSize(ByteBuffer message) {
        return message.getInt(message.position());
    }

    public static int getMagicCode(ByteBuffer message) {
        return message.getInt(message.position() + 4);
    }

    public static long getQueueOffset(ByteBuffer message) {
        return message.getLong(message.position() + 20);
    }

    public static long getCommitLogOffset(ByteBuffer message) {
        return message.getLong(message.position() + 28);
    }

    public static long getStoreTimeStamp(ByteBuffer message) {
        return message.getLong(message.position() + 56);
    }

    public static ByteBuffer getOffsetIdBuffer(ByteBuffer message) {
        ByteBuffer idBuffer = ByteBuffer.allocate(16);
        idBuffer.limit(16);
        idBuffer.putLong(message.getLong(message.position() + 64));
        idBuffer.putLong(MessageBufferUtil.getCommitLogOffset(message));
        idBuffer.flip();
        return idBuffer;
    }

    public static String getOffsetId(ByteBuffer message) {
        return UtilAll.bytes2string((byte[])MessageBufferUtil.getOffsetIdBuffer(message).array());
    }

    public static Map<String, String> getProperties(ByteBuffer message) {
        ByteBuffer slice = message.slice();
        return MessageDecoder.decodeProperties((ByteBuffer)slice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Integer, Integer>> splitMessageBuffer(ByteBuffer cqBuffer, ByteBuffer msgBuffer) {
        cqBuffer.rewind();
        msgBuffer.rewind();
        ArrayList<Pair<Integer, Integer>> messageList = new ArrayList<Pair<Integer, Integer>>(cqBuffer.remaining() / 20);
        if (cqBuffer.remaining() % 20 != 0) {
            logger.warn("MessageBufferUtil#splitMessage: consume queue buffer size {} is not an integer multiple of CONSUME_QUEUE_STORE_UNIT_SIZE {}", (Object)cqBuffer.remaining(), (Object)20);
            return messageList;
        }
        try {
            long startCommitLogOffset = CQItemBufferUtil.getCommitLogOffset(cqBuffer);
            for (int pos = cqBuffer.position(); pos < cqBuffer.limit(); pos += 20) {
                cqBuffer.position(pos);
                int diff = (int)(CQItemBufferUtil.getCommitLogOffset(cqBuffer) - startCommitLogOffset);
                int size = CQItemBufferUtil.getSize(cqBuffer);
                if (diff + size > msgBuffer.limit()) {
                    logger.error("MessageBufferUtil#splitMessage: message buffer size is incorrect: record in consume queue: {}, actual: {}", (Object)(diff + size), (Object)msgBuffer.remaining());
                    ArrayList<Pair<Integer, Integer>> arrayList = messageList;
                    return arrayList;
                }
                msgBuffer.position(diff);
                int magicCode = MessageBufferUtil.getMagicCode(msgBuffer);
                if (magicCode == -875286124) {
                    logger.warn("MessageBufferUtil#splitMessage: message decode error: blank magic code, this message may be coda, try to fix offset");
                    msgBuffer.position(diff += 16);
                    magicCode = MessageBufferUtil.getMagicCode(msgBuffer);
                }
                if (magicCode != -626843481 && magicCode != -626843477) {
                    logger.warn("MessageBufferUtil#splitMessage: message decode error: unknown magic code");
                    continue;
                }
                if (MessageBufferUtil.getTotalSize(msgBuffer) != size) {
                    logger.warn("MessageBufferUtil#splitMessage: message size is not right: except: {}, actual: {}", (Object)size, (Object)MessageBufferUtil.getTotalSize(msgBuffer));
                    continue;
                }
                messageList.add((Pair<Integer, Integer>)Pair.of((Object)diff, (Object)size));
            }
        }
        catch (Exception e) {
            logger.error("MessageBufferUtil#splitMessage: split message failed, maybe decode consume queue item failed", (Throwable)e);
        }
        finally {
            cqBuffer.rewind();
            msgBuffer.rewind();
        }
        return messageList;
    }
}

