/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.tracemessage;

import io.jaegertracing.Configuration;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.hook.SendMessageHook;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.trace.hook.SendMessageOpenTracingHookImpl;
import org.apache.rocketmq.common.message.Message;

public class OpenTracingProducer {
    public static final String PRODUCER_GROUP = "ProducerGroupName";
    public static final String DEFAULT_NAMESRVADDR = "127.0.0.1:9876";
    public static final String TOPIC = "TopicTest";
    public static final String TAG = "TagA";
    public static final String KEY = "OrderID188";

    public static void main(String[] args) throws MQClientException {
        Tracer tracer = OpenTracingProducer.initTracer();
        DefaultMQProducer producer = new DefaultMQProducer(PRODUCER_GROUP);
        producer.getDefaultMQProducerImpl().registerSendMessageHook((SendMessageHook)new SendMessageOpenTracingHookImpl(tracer));
        producer.start();
        try {
            Message msg = new Message(TOPIC, TAG, KEY, "Hello world".getBytes("UTF-8"));
            SendResult sendResult = producer.send(msg);
            System.out.printf("%s%n", sendResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        producer.shutdown();
    }

    private static Tracer initTracer() {
        Configuration.SamplerConfiguration samplerConfig = Configuration.SamplerConfiguration.fromEnv().withType("const").withParam((Number)1);
        Configuration.ReporterConfiguration reporterConfig = Configuration.ReporterConfiguration.fromEnv().withLogSpans(Boolean.valueOf(true));
        Configuration config = new Configuration("rocketmq").withSampler(samplerConfig).withReporter(reporterConfig);
        GlobalTracer.registerIfAbsent((Tracer)config.getTracer());
        return config.getTracer();
    }
}

