/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.store.file;

import io.openmessaging.storage.dledger.store.file.MmapFile;
import java.nio.ByteBuffer;

public class SelectMmapBufferResult {
    private final long startOffset;
    private final ByteBuffer byteBuffer;
    protected MmapFile mappedFile;
    private int size;

    public SelectMmapBufferResult(long startOffset, ByteBuffer byteBuffer, int size, MmapFile mappedFile) {
        this.startOffset = startOffset;
        this.byteBuffer = byteBuffer;
        this.size = size;
        this.mappedFile = mappedFile;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int s) {
        this.size = s;
        this.byteBuffer.limit(this.size);
    }

    public MmapFile getMappedFile() {
        return this.mappedFile;
    }

    public synchronized void release() {
        if (this.mappedFile != null) {
            this.mappedFile.release();
            this.mappedFile = null;
        }
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public static void release(SelectMmapBufferResult sbr) {
        if (sbr != null) {
            sbr.release();
        }
    }
}

