/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.offset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.RocksDBConfigManager;
import org.apache.rocketmq.broker.offset.ConsumerOffsetManager;
import org.apache.rocketmq.broker.offset.RocksDBOffsetSerializeWrapper;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.rocksdb.WriteBatch;

public class RocksDBConsumerOffsetManager
extends ConsumerOffsetManager {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    protected RocksDBConfigManager rocksDBConfigManager;

    public RocksDBConsumerOffsetManager(BrokerController brokerController) {
        super(brokerController);
        this.rocksDBConfigManager = new RocksDBConfigManager(this.rocksdbConfigFilePath(), brokerController.getMessageStoreConfig().getMemTableFlushIntervalMs());
    }

    public boolean load() {
        if (!this.rocksDBConfigManager.init()) {
            return false;
        }
        return this.loadDataVersion() && this.loadConsumerOffset();
    }

    public boolean loadConsumerOffset() {
        return this.rocksDBConfigManager.loadData(this::decodeOffset) && this.merge();
    }

    private boolean merge() {
        if (!this.brokerController.getMessageStoreConfig().isTransferOffsetJsonToRocksdb()) {
            log.info("the switch transferOffsetJsonToRocksdb is off, no merge offset operation is needed.");
            return true;
        }
        if (!UtilAll.isPathExists((String)this.configFilePath()) && !UtilAll.isPathExists((String)(this.configFilePath() + ".bak"))) {
            log.info("consumerOffset json file does not exist, so skip merge");
            return true;
        }
        if (!super.loadDataVersion()) {
            log.error("load json consumerOffset dataVersion error, startup will exit");
            return false;
        }
        DataVersion dataVersion = super.getDataVersion();
        DataVersion kvDataVersion = this.getDataVersion();
        if (dataVersion.getCounter().get() > kvDataVersion.getCounter().get()) {
            if (!super.load()) {
                log.error("load json consumerOffset info failed, startup will exit");
                return false;
            }
            this.persist();
            this.getDataVersion().assignNewOne(dataVersion);
            this.updateDataVersion();
            log.info("update offset from json, dataVersion:{}, offsetTable: {} ", (Object)this.getDataVersion(), (Object)JSON.toJSONString(this.getOffsetTable()));
        }
        return true;
    }

    public boolean stop() {
        return this.rocksDBConfigManager.stop();
    }

    @Override
    protected void removeConsumerOffset(String topicAtGroup) {
        try {
            byte[] keyBytes = topicAtGroup.getBytes(DataConverter.CHARSET_UTF8);
            this.rocksDBConfigManager.delete(keyBytes);
        }
        catch (Exception e) {
            LOG.error("kv remove consumerOffset Failed, {}", (Object)topicAtGroup);
        }
    }

    protected void decodeOffset(byte[] key, byte[] body) {
        String topicAtGroup = new String(key, DataConverter.CHARSET_UTF8);
        RocksDBOffsetSerializeWrapper wrapper = (RocksDBOffsetSerializeWrapper)((Object)JSON.parseObject((byte[])body, RocksDBOffsetSerializeWrapper.class, (Feature[])new Feature[0]));
        this.offsetTable.put(topicAtGroup, wrapper.getOffsetTable());
        LOG.info("load exist local offset, {}, {}", (Object)topicAtGroup, wrapper.getOffsetTable());
    }

    public String rocksdbConfigFilePath() {
        return this.brokerController.getMessageStoreConfig().getStorePathRootDir() + File.separator + "config" + File.separator + "consumerOffsets" + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persist() {
        try (WriteBatch writeBatch = new WriteBatch();){
            for (Map.Entry entry : this.offsetTable.entrySet()) {
                this.putWriteBatch(writeBatch, (String)entry.getKey(), (ConcurrentMap)entry.getValue());
                if (writeBatch.getDataSize() < 4096L) continue;
                this.rocksDBConfigManager.batchPutWithWal(writeBatch);
            }
            this.rocksDBConfigManager.batchPutWithWal(writeBatch);
            this.rocksDBConfigManager.flushWAL();
        }
    }

    private void putWriteBatch(WriteBatch writeBatch, String topicGroupName, ConcurrentMap<Integer, Long> offsetMap) throws Exception {
        byte[] keyBytes = topicGroupName.getBytes(DataConverter.CHARSET_UTF8);
        RocksDBOffsetSerializeWrapper wrapper = new RocksDBOffsetSerializeWrapper();
        wrapper.setOffsetTable(offsetMap);
        byte[] valueBytes = JSON.toJSONBytes((Object)((Object)wrapper), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.BrowserCompatible});
        writeBatch.put(keyBytes, valueBytes);
    }

    @Override
    public boolean loadDataVersion() {
        return this.rocksDBConfigManager.loadDataVersion();
    }

    @Override
    public DataVersion getDataVersion() {
        return this.rocksDBConfigManager.getKvDataVersion();
    }

    public void updateDataVersion() {
        try {
            this.rocksDBConfigManager.updateKvDataVersion();
        }
        catch (Exception e) {
            log.error("update consumer offset dataVersion error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

