/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.controller.impl.event.EventMessage;

public class ControllerResult<T> {
    private final List<EventMessage> events;
    private final T response;
    private byte[] body;
    private int responseCode = 0;
    private String remark;

    public ControllerResult() {
        this(null);
    }

    public ControllerResult(T response) {
        this.events = new ArrayList<EventMessage>();
        this.response = response;
    }

    public ControllerResult(List<EventMessage> events, T response) {
        this.events = new ArrayList<EventMessage>(events);
        this.response = response;
    }

    public static <T> ControllerResult<T> of(List<EventMessage> events, T response) {
        return new ControllerResult<T>(events, response);
    }

    public List<EventMessage> getEvents() {
        return new ArrayList<EventMessage>(this.events);
    }

    public T getResponse() {
        return this.response;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setCodeAndRemark(int responseCode, String remark) {
        this.responseCode = responseCode;
        this.remark = remark;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getRemark() {
        return this.remark;
    }

    public void addEvent(EventMessage event) {
        this.events.add(event);
    }

    public String toString() {
        return "ControllerResult{events=" + this.events + ", response=" + this.response + '}';
    }
}

