/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.ha;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.remoting.protocol.body.HARuntimeInfo;
import org.apache.rocketmq.store.CommitLog;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.ha.HAClient;
import org.apache.rocketmq.store.ha.HAConnection;
import org.apache.rocketmq.store.ha.HAConnectionStateNotificationRequest;
import org.apache.rocketmq.store.ha.WaitNotifyObject;
import org.rocksdb.RocksDBException;

public interface HAService {
    public void init(DefaultMessageStore var1) throws IOException;

    public void start() throws Exception;

    public void shutdown();

    default public boolean changeToMaster(int masterEpoch) throws RocksDBException {
        return false;
    }

    default public boolean changeToMasterWhenLastRoleIsMaster(int masterEpoch) {
        return false;
    }

    default public boolean changeToSlave(String newMasterAddr, int newMasterEpoch, Long slaveId) {
        return false;
    }

    default public boolean changeToSlaveWhenMasterNotChange(String newMasterAddr, int newMasterEpoch) {
        return false;
    }

    public void updateMasterAddress(String var1);

    public void updateHaMasterAddress(String var1);

    public int inSyncReplicasNums(long var1);

    public AtomicInteger getConnectionCount();

    public void putRequest(CommitLog.GroupCommitRequest var1);

    public void putGroupConnectionStateRequest(HAConnectionStateNotificationRequest var1);

    public List<HAConnection> getConnectionList();

    public HAClient getHAClient();

    public AtomicLong getPush2SlaveMaxOffset();

    public HARuntimeInfo getRuntimeInfo(long var1);

    public WaitNotifyObject getWaitNotifyObject();

    public boolean isSlaveOK(long var1);
}

