/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.rocksdb;

import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.MessageStore;
import org.rocksdb.AbstractCompactionFilter;
import org.rocksdb.AbstractCompactionFilterFactory;
import org.rocksdb.RemoveConsumeQueueCompactionFilter;

public class ConsumeQueueCompactionFilterFactory
extends AbstractCompactionFilterFactory<RemoveConsumeQueueCompactionFilter> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqRocksDB");
    private final MessageStore messageStore;

    public ConsumeQueueCompactionFilterFactory(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public String name() {
        return "ConsumeQueueCompactionFilterFactory";
    }

    public RemoveConsumeQueueCompactionFilter createCompactionFilter(AbstractCompactionFilter.Context context) {
        long minPhyOffset = this.messageStore.getMinPhyOffset();
        LOGGER.info("manualCompaction minPhyOffset: {}, isFull: {}, isManual: {}", new Object[]{minPhyOffset, context.isFullCompaction(), context.isManualCompaction()});
        return new RemoveConsumeQueueCompactionFilter(minPhyOffset);
    }
}

