/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.export;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class ExportConfigsCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "exportConfigs";
    }

    @Override
    public String commandDesc() {
        return "Export configs.";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("c", "clusterName", true, "choose a cluster to export");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("f", "filePath", true, "export configs.json path | default /tmp/rocketmq/export");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            String clusterName = commandLine.getOptionValue('c').trim();
            String filePath = !commandLine.hasOption('f') ? "/tmp/rocketmq/export" : commandLine.getOptionValue('f').trim();
            defaultMQAdminExt.start();
            HashMap result = new HashMap();
            List<String> nameServerAddressList = defaultMQAdminExt.getNameServerAddressList();
            int masterBrokerSize = 0;
            int slaveBrokerSize = 0;
            HashMap<String, Properties> brokerConfigs = new HashMap<String, Properties>();
            Map<String, List<String>> masterAndSlaveMap = CommandUtil.fetchMasterAndSlaveDistinguish(defaultMQAdminExt, clusterName);
            for (Map.Entry<String, List<String>> masterAndSlaveEntry : masterAndSlaveMap.entrySet()) {
                Properties masterProperties = defaultMQAdminExt.getBrokerConfig(masterAndSlaveEntry.getKey());
                ++masterBrokerSize;
                slaveBrokerSize += masterAndSlaveEntry.getValue().size();
                brokerConfigs.put(masterProperties.getProperty("brokerName"), this.needBrokerProprties(masterProperties));
            }
            HashMap<String, Integer> clusterScaleMap = new HashMap<String, Integer>();
            clusterScaleMap.put("namesrvSize", nameServerAddressList.size());
            clusterScaleMap.put("masterBrokerSize", masterBrokerSize);
            clusterScaleMap.put("slaveBrokerSize", slaveBrokerSize);
            result.put("brokerConfigs", brokerConfigs);
            result.put("clusterScale", clusterScaleMap);
            String path = filePath + "/configs.json";
            MixAll.string2FileNotSafe((String)JSON.toJSONString(result, (boolean)true), (String)path);
            System.out.printf("export %s success", path);
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }

    private Properties needBrokerProprties(Properties properties) {
        List<String> propertyKeys = Arrays.asList("brokerClusterName", "brokerId", "brokerName", "brokerRole", "fileReservedTime", "filterServerNums", "flushDiskType", "maxMessageSize", "messageDelayLevel", "msgTraceTopicName", "slaveReadEnable", "traceOn", "traceTopicEnable", "useTLS", "autoCreateTopicEnable", "autoCreateSubscriptionGroup");
        Properties newProperties = new Properties();
        propertyKeys.stream().filter(key -> properties.getProperty((String)key) != null).forEach(key -> newProperties.setProperty((String)key, properties.getProperty((String)key)));
        return newProperties;
    }
}

