/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.admin;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.protocol.admin.OffsetWrapper;

public class ConsumeStats
extends RemotingSerializable {
    private Map<MessageQueue, OffsetWrapper> offsetTable = new ConcurrentHashMap<MessageQueue, OffsetWrapper>();
    private double consumeTps = 0.0;

    public long computeTotalDiff() {
        long diffTotal = 0L;
        for (Map.Entry<MessageQueue, OffsetWrapper> entry : this.offsetTable.entrySet()) {
            diffTotal += entry.getValue().getBrokerOffset() - entry.getValue().getConsumerOffset();
        }
        return diffTotal;
    }

    public long computeInflightTotalDiff() {
        long diffTotal = 0L;
        for (Map.Entry<MessageQueue, OffsetWrapper> entry : this.offsetTable.entrySet()) {
            diffTotal += entry.getValue().getPullOffset() - entry.getValue().getConsumerOffset();
        }
        return diffTotal;
    }

    public Map<MessageQueue, OffsetWrapper> getOffsetTable() {
        return this.offsetTable;
    }

    public void setOffsetTable(Map<MessageQueue, OffsetWrapper> offsetTable) {
        this.offsetTable = offsetTable;
    }

    public double getConsumeTps() {
        return this.consumeTps;
    }

    public void setConsumeTps(double consumeTps) {
        this.consumeTps = consumeTps;
    }
}

