/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.core;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class NodeMetrics {
    private final MetricRegistry metrics;

    public NodeMetrics(boolean enableMetrics) {
        this.metrics = enableMetrics ? new MetricRegistry() : null;
    }

    public Map<String, Metric> getMetrics() {
        if (this.metrics != null) {
            return this.metrics.getMetrics();
        }
        return Collections.emptyMap();
    }

    public MetricRegistry getMetricRegistry() {
        return this.metrics;
    }

    public boolean isEnabled() {
        return this.metrics != null;
    }

    public void recordTimes(String key, long times) {
        if (this.metrics != null) {
            this.metrics.counter(key).inc(times);
        }
    }

    public void recordSize(String key, long size) {
        if (this.metrics != null) {
            this.metrics.histogram(key).update(size);
        }
    }

    public void recordLatency(String key, long duration) {
        if (this.metrics != null) {
            this.metrics.timer(key).update(duration, TimeUnit.MILLISECONDS);
        }
    }
}

