/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.util;

import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Platform {
    private static final Logger LOG = LoggerFactory.getLogger(Platform.class);
    private static final boolean IS_WINDOWS = Platform.isWindows0();
    private static final boolean IS_MAC = Platform.isMac0();
    private static final boolean IS_LINUX = Platform.isLinux0();

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isMac() {
        return IS_MAC;
    }

    public static boolean isLinux() {
        return IS_LINUX;
    }

    private static boolean isMac0() {
        boolean mac = SystemPropertyUtil.get("os.name", "").toLowerCase(Locale.US).contains("mac os x");
        if (mac) {
            LOG.debug("Platform: Mac OS X");
        }
        return mac;
    }

    private static boolean isWindows0() {
        boolean windows = SystemPropertyUtil.get("os.name", "").toLowerCase(Locale.US).contains("win");
        if (windows) {
            LOG.debug("Platform: Windows");
        }
        return windows;
    }

    private static boolean isLinux0() {
        boolean linux = SystemPropertyUtil.get("os.name", "").toLowerCase(Locale.US).contains("linux");
        if (linux) {
            LOG.debug("Platform: Linux");
        }
        return linux;
    }
}

