/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.hessian.generic.io;

import com.alipay.hessian.generic.model.GenericArray;
import com.alipay.hessian.generic.model.GenericCollection;
import com.alipay.hessian.generic.model.GenericMap;
import com.alipay.hessian.generic.model.GenericObject;
import com.alipay.hessian.generic.util.ClassFilter;
import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.CollectionDeserializer;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.MapDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenericDeserializer
extends AbstractDeserializer {
    private final String type;
    private static final Deserializer DEFAULT_MAP_DESERIALIZER = new MapDeserializer(HashMap.class);
    private static final Deserializer DEFAULT_COLLECTION_DESERIALIZER = new CollectionDeserializer(ArrayList.class);
    public static final char ARRAY_PREFIX = '[';

    public GenericDeserializer(String type) {
        this.type = type;
    }

    @Override
    public Object readList(AbstractHessianInput in, int length) throws IOException {
        List list = (List)DEFAULT_COLLECTION_DESERIALIZER.readList(in, length);
        return this.convertGeneric(length, list);
    }

    @Override
    public Object readLengthList(AbstractHessianInput in, int length) throws IOException {
        List list = (List)DEFAULT_COLLECTION_DESERIALIZER.readLengthList(in, length);
        return this.convertGeneric(length, list);
    }

    @Override
    public Object readMap(AbstractHessianInput in) throws IOException {
        Map map = (Map)DEFAULT_MAP_DESERIALIZER.readMap(in);
        GenericMap genericMap = new GenericMap(this.type);
        genericMap.setMap(map);
        return genericMap;
    }

    @Override
    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        GenericObject obj = new GenericObject(this.type);
        return GenericDeserializer.readGenericObject(in, obj, fieldNames);
    }

    private static GenericObject readGenericObject(AbstractHessianInput in, GenericObject obj, String[] fieldNames) throws IOException {
        in.addRef(obj);
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            Object value = in.readObject();
            obj.putField(fieldName, value);
        }
        return obj;
    }

    private Object convertGeneric(int length, List list) {
        if (this.type.charAt(0) == '[') {
            Object[] objects = new Object[length];
            for (int i = 0; i < list.size(); ++i) {
                objects[i] = list.get(i);
            }
            GenericArray ga = new GenericArray(ClassFilter.decodeObjectAndDate(this.type.substring(1)));
            ga.setObjects(objects);
            return ga;
        }
        GenericCollection gc = new GenericCollection(this.type);
        gc.setCollection(list);
        return gc;
    }
}

