/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.ha;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.body.HARuntimeInfo;
import org.apache.rocketmq.store.CommitLog;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.ha.DefaultHAClient;
import org.apache.rocketmq.store.ha.DefaultHAConnection;
import org.apache.rocketmq.store.ha.GroupTransferService;
import org.apache.rocketmq.store.ha.HAClient;
import org.apache.rocketmq.store.ha.HAConnection;
import org.apache.rocketmq.store.ha.HAConnectionStateNotificationRequest;
import org.apache.rocketmq.store.ha.HAConnectionStateNotificationService;
import org.apache.rocketmq.store.ha.HAService;
import org.apache.rocketmq.store.ha.WaitNotifyObject;

public class DefaultHAService
implements HAService {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    protected final AtomicInteger connectionCount = new AtomicInteger(0);
    protected final List<HAConnection> connectionList = new LinkedList<HAConnection>();
    protected AcceptSocketService acceptSocketService;
    protected DefaultMessageStore defaultMessageStore;
    protected WaitNotifyObject waitNotifyObject = new WaitNotifyObject();
    protected AtomicLong push2SlaveMaxOffset = new AtomicLong(0L);
    protected GroupTransferService groupTransferService;
    protected HAClient haClient;
    protected HAConnectionStateNotificationService haConnectionStateNotificationService;

    @Override
    public void init(DefaultMessageStore defaultMessageStore) throws IOException {
        this.defaultMessageStore = defaultMessageStore;
        this.acceptSocketService = new DefaultAcceptSocketService(defaultMessageStore.getMessageStoreConfig());
        this.groupTransferService = new GroupTransferService(this, defaultMessageStore);
        if (this.defaultMessageStore.getMessageStoreConfig().getBrokerRole() == BrokerRole.SLAVE) {
            this.haClient = new DefaultHAClient(this.defaultMessageStore);
        }
        this.haConnectionStateNotificationService = new HAConnectionStateNotificationService(this, defaultMessageStore);
    }

    @Override
    public void updateMasterAddress(String newAddr) {
        if (this.haClient != null) {
            this.haClient.updateMasterAddress(newAddr);
        }
    }

    @Override
    public void updateHaMasterAddress(String newAddr) {
        if (this.haClient != null) {
            this.haClient.updateHaMasterAddress(newAddr);
        }
    }

    @Override
    public void putRequest(CommitLog.GroupCommitRequest request) {
        this.groupTransferService.putRequest(request);
    }

    @Override
    public boolean isSlaveOK(long masterPutWhere) {
        boolean result = this.connectionCount.get() > 0;
        result = result && masterPutWhere - this.push2SlaveMaxOffset.get() < (long)this.defaultMessageStore.getMessageStoreConfig().getHaMaxGapNotInSync();
        return result;
    }

    public void notifyTransferSome(long offset) {
        long value = this.push2SlaveMaxOffset.get();
        while (offset > value) {
            boolean ok = this.push2SlaveMaxOffset.compareAndSet(value, offset);
            if (ok) {
                this.groupTransferService.notifyTransferSome();
                break;
            }
            value = this.push2SlaveMaxOffset.get();
        }
    }

    @Override
    public AtomicInteger getConnectionCount() {
        return this.connectionCount;
    }

    @Override
    public void start() throws Exception {
        this.acceptSocketService.beginAccept();
        this.acceptSocketService.start();
        this.groupTransferService.start();
        this.haConnectionStateNotificationService.start();
        if (this.haClient != null) {
            this.haClient.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(HAConnection conn) {
        List<HAConnection> list = this.connectionList;
        synchronized (list) {
            this.connectionList.add(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(HAConnection conn) {
        this.haConnectionStateNotificationService.checkConnectionStateAndNotify(conn);
        List<HAConnection> list = this.connectionList;
        synchronized (list) {
            this.connectionList.remove(conn);
        }
    }

    @Override
    public void shutdown() {
        if (this.haClient != null) {
            this.haClient.shutdown();
        }
        if (this.acceptSocketService != null) {
            this.acceptSocketService.shutdown(true);
        }
        this.destroyConnections();
        if (this.groupTransferService != null) {
            this.groupTransferService.shutdown();
        }
        if (this.haConnectionStateNotificationService != null) {
            this.haConnectionStateNotificationService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConnections() {
        List<HAConnection> list = this.connectionList;
        synchronized (list) {
            for (HAConnection c : this.connectionList) {
                c.shutdown();
            }
            this.connectionList.clear();
        }
    }

    public DefaultMessageStore getDefaultMessageStore() {
        return this.defaultMessageStore;
    }

    @Override
    public WaitNotifyObject getWaitNotifyObject() {
        return this.waitNotifyObject;
    }

    @Override
    public AtomicLong getPush2SlaveMaxOffset() {
        return this.push2SlaveMaxOffset;
    }

    @Override
    public int inSyncReplicasNums(long masterPutWhere) {
        int inSyncNums = 1;
        for (HAConnection conn : this.connectionList) {
            if (!this.isInSyncSlave(masterPutWhere, conn)) continue;
            ++inSyncNums;
        }
        return inSyncNums;
    }

    protected boolean isInSyncSlave(long masterPutWhere, HAConnection conn) {
        return masterPutWhere - conn.getSlaveAckOffset() < (long)this.defaultMessageStore.getMessageStoreConfig().getHaMaxGapNotInSync();
    }

    @Override
    public void putGroupConnectionStateRequest(HAConnectionStateNotificationRequest request) {
        this.haConnectionStateNotificationService.setRequest(request);
    }

    @Override
    public List<HAConnection> getConnectionList() {
        return this.connectionList;
    }

    @Override
    public HAClient getHAClient() {
        return this.haClient;
    }

    @Override
    public HARuntimeInfo getRuntimeInfo(long masterPutWhere) {
        HARuntimeInfo info = new HARuntimeInfo();
        if (BrokerRole.SLAVE.equals((Object)this.getDefaultMessageStore().getMessageStoreConfig().getBrokerRole())) {
            info.setMaster(false);
            info.getHaClientRuntimeInfo().setMasterAddr(this.haClient.getHaMasterAddress());
            info.getHaClientRuntimeInfo().setMaxOffset(this.getDefaultMessageStore().getMaxPhyOffset());
            info.getHaClientRuntimeInfo().setLastReadTimestamp(this.haClient.getLastReadTimestamp());
            info.getHaClientRuntimeInfo().setLastWriteTimestamp(this.haClient.getLastWriteTimestamp());
            info.getHaClientRuntimeInfo().setTransferredByteInSecond(this.haClient.getTransferredByteInSecond());
            info.getHaClientRuntimeInfo().setMasterFlushOffset(this.defaultMessageStore.getMasterFlushedOffset());
        } else {
            info.setMaster(true);
            int inSyncNums = 0;
            info.setMasterCommitLogMaxOffset(masterPutWhere);
            for (HAConnection conn : this.connectionList) {
                HARuntimeInfo.HAConnectionRuntimeInfo cInfo = new HARuntimeInfo.HAConnectionRuntimeInfo();
                long slaveAckOffset = conn.getSlaveAckOffset();
                cInfo.setSlaveAckOffset(slaveAckOffset);
                cInfo.setDiff(masterPutWhere - slaveAckOffset);
                cInfo.setAddr(conn.getClientAddress().substring(1));
                cInfo.setTransferredByteInSecond(conn.getTransferredByteInSecond());
                cInfo.setTransferFromWhere(conn.getTransferFromWhere());
                boolean isInSync = this.isInSyncSlave(masterPutWhere, conn);
                if (isInSync) {
                    ++inSyncNums;
                }
                cInfo.setInSync(isInSync);
                info.getHaConnectionInfo().add(cInfo);
            }
            info.setInSyncSlaveNums(inSyncNums);
        }
        return info;
    }

    protected abstract class AcceptSocketService
    extends ServiceThread {
        private final SocketAddress socketAddressListen;
        private ServerSocketChannel serverSocketChannel;
        private Selector selector;
        private final MessageStoreConfig messageStoreConfig;

        public AcceptSocketService(MessageStoreConfig messageStoreConfig) {
            this.messageStoreConfig = messageStoreConfig;
            this.socketAddressListen = new InetSocketAddress(messageStoreConfig.getHaListenPort());
        }

        public void beginAccept() throws Exception {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.selector = NetworkUtil.openSelector();
            this.serverSocketChannel.socket().setReuseAddress(true);
            this.serverSocketChannel.socket().bind(this.socketAddressListen);
            if (0 == this.messageStoreConfig.getHaListenPort()) {
                this.messageStoreConfig.setHaListenPort(this.serverSocketChannel.socket().getLocalPort());
                log.info("OS picked up {} to listen for HA", (Object)this.messageStoreConfig.getHaListenPort());
            }
            this.serverSocketChannel.configureBlocking(false);
            this.serverSocketChannel.register(this.selector, 16);
        }

        public void shutdown(boolean interrupt) {
            super.shutdown(interrupt);
            try {
                if (null != this.serverSocketChannel) {
                    this.serverSocketChannel.close();
                }
                if (null != this.selector) {
                    this.selector.close();
                }
            }
            catch (IOException e) {
                log.error("AcceptSocketService shutdown exception", (Throwable)e);
            }
        }

        public void run() {
            log.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                try {
                    this.selector.select(1000L);
                    Set<SelectionKey> selected = this.selector.selectedKeys();
                    if (selected == null) continue;
                    for (SelectionKey k : selected) {
                        if (k.isAcceptable()) {
                            SocketChannel sc = ((ServerSocketChannel)k.channel()).accept();
                            if (sc == null) continue;
                            log.info("HAService receive new connection, " + sc.socket().getRemoteSocketAddress());
                            try {
                                HAConnection conn = this.createConnection(sc);
                                DefaultHAService.this.addConnection(conn);
                                conn.start();
                            }
                            catch (Exception e) {
                                log.error("new HAConnection exception", (Throwable)e);
                                sc.close();
                            }
                            continue;
                        }
                        log.warn("Unexpected ops in select " + k.readyOps());
                    }
                    selected.clear();
                }
                catch (Exception e) {
                    log.error(this.getServiceName() + " service has exception.", (Throwable)e);
                }
            }
            log.info(this.getServiceName() + " service end");
        }

        protected abstract HAConnection createConnection(SocketChannel var1) throws IOException;
    }

    class DefaultAcceptSocketService
    extends AcceptSocketService {
        public DefaultAcceptSocketService(MessageStoreConfig messageStoreConfig) {
            super(messageStoreConfig);
        }

        @Override
        protected HAConnection createConnection(SocketChannel sc) throws IOException {
            return new DefaultHAConnection(DefaultHAService.this, sc);
        }

        public String getServiceName() {
            if (DefaultHAService.this.defaultMessageStore.getBrokerConfig().isInBrokerContainer()) {
                return DefaultHAService.this.defaultMessageStore.getBrokerConfig().getIdentifier() + AcceptSocketService.class.getSimpleName();
            }
            return DefaultAcceptSocketService.class.getSimpleName();
        }
    }
}

