/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.metrics;

import com.google.common.collect.Lists;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.ViewBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.metrics.NopLongCounter;
import org.apache.rocketmq.common.metrics.NopLongHistogram;
import org.apache.rocketmq.common.metrics.NopObservableLongGauge;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.metrics.RocksDBStoreMetricsManager;
import org.apache.rocketmq.store.metrics.StoreMetricsManager;
import org.apache.rocketmq.store.timer.Slot;
import org.apache.rocketmq.store.timer.TimerMessageStore;
import org.apache.rocketmq.store.timer.TimerMetrics;
import org.apache.rocketmq.store.timer.TimerWheel;

public class DefaultStoreMetricsManager
implements StoreMetricsManager {
    private Supplier<AttributesBuilder> attributesBuilderSupplier;
    private MessageStoreConfig messageStoreConfig;
    private ObservableLongGauge storageSize = new NopObservableLongGauge();
    private ObservableLongGauge flushBehind = new NopObservableLongGauge();
    private ObservableLongGauge dispatchBehind = new NopObservableLongGauge();
    private ObservableLongGauge messageReserveTime = new NopObservableLongGauge();
    private ObservableLongGauge timerEnqueueLag = new NopObservableLongGauge();
    private ObservableLongGauge timerEnqueueLatency = new NopObservableLongGauge();
    private ObservableLongGauge timerDequeueLag = new NopObservableLongGauge();
    private ObservableLongGauge timerDequeueLatency = new NopObservableLongGauge();
    private ObservableLongGauge timingMessages = new NopObservableLongGauge();
    private LongCounter timerDequeueTotal = new NopLongCounter();
    private LongCounter timerEnqueueTotal = new NopLongCounter();
    private ObservableLongGauge timerMessageSnapshot = new NopObservableLongGauge();
    private LongHistogram timerMessageSetLatency = new NopLongHistogram();
    private RocksDBStoreMetricsManager rocksDBStoreMetricsManager = new RocksDBStoreMetricsManager();

    @Override
    public List<Pair<InstrumentSelector, ViewBuilder>> getMetricsView() {
        List<Double> rpcCostTimeBuckets = Arrays.asList(60.0, 600.0, 3600.0, 43200.0, 86400.0, 259200.0);
        InstrumentSelector selector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_delay_message_latency").build();
        ViewBuilder viewBuilder = View.builder().setAggregation(Aggregation.explicitBucketHistogram(rpcCostTimeBuckets));
        return Lists.newArrayList((Object[])new Pair[]{new Pair((Object)selector, (Object)viewBuilder)});
    }

    @Override
    public void init(Meter meter, Supplier<AttributesBuilder> attributesBuilderSupplier, MessageStore messageStore) {
        this.rocksDBStoreMetricsManager.init(meter, attributesBuilderSupplier, messageStore.getQueueStore());
        this.attributesBuilderSupplier = attributesBuilderSupplier;
        this.messageStoreConfig = messageStore.getMessageStoreConfig();
        this.storageSize = meter.gaugeBuilder("rocketmq_storage_size").setDescription("Broker storage size").setUnit("bytes").ofLongs().buildWithCallback(measurement -> {
            long totalSpace;
            File storeDir = new File(this.messageStoreConfig.getStorePathRootDir());
            if (storeDir.exists() && storeDir.isDirectory() && (totalSpace = storeDir.getTotalSpace()) > 0L) {
                measurement.record(totalSpace - storeDir.getFreeSpace(), this.newAttributesBuilder().build());
            }
        });
        this.flushBehind = meter.gaugeBuilder("rocketmq_storage_flush_behind_bytes").setDescription("Broker flush behind bytes").setUnit("bytes").ofLongs().buildWithCallback(measurement -> measurement.record(messageStore.flushBehindBytes(), this.newAttributesBuilder().build()));
        this.dispatchBehind = meter.gaugeBuilder("rocketmq_storage_dispatch_behind_bytes").setDescription("Broker dispatch behind bytes").setUnit("bytes").ofLongs().buildWithCallback(measurement -> measurement.record(messageStore.dispatchBehindBytes(), this.newAttributesBuilder().build()));
        this.messageReserveTime = meter.gaugeBuilder("rocketmq_storage_message_reserve_time").setDescription("Broker message reserve time").setUnit("milliseconds").ofLongs().buildWithCallback(measurement -> {
            long earliestMessageTime = messageStore.getEarliestMessageTime();
            if (earliestMessageTime <= 0L) {
                return;
            }
            measurement.record(System.currentTimeMillis() - earliestMessageTime, this.newAttributesBuilder().build());
        });
        if (messageStore.getMessageStoreConfig().isTimerWheelEnable()) {
            this.timerEnqueueLag = meter.gaugeBuilder("rocketmq_timer_enqueue_lag").setDescription("Timer enqueue messages lag").ofLongs().buildWithCallback(measurement -> {
                TimerMessageStore timerMessageStore = messageStore.getTimerMessageStore();
                measurement.record(timerMessageStore.getEnqueueBehindMessages(), this.newAttributesBuilder().build());
            });
            this.timerEnqueueLatency = meter.gaugeBuilder("rocketmq_timer_enqueue_latency").setDescription("Timer enqueue latency").setUnit("milliseconds").ofLongs().buildWithCallback(measurement -> {
                TimerMessageStore timerMessageStore = messageStore.getTimerMessageStore();
                measurement.record(timerMessageStore.getEnqueueBehindMillis(), this.newAttributesBuilder().build());
            });
            this.timerDequeueLag = meter.gaugeBuilder("rocketmq_timer_dequeue_lag").setDescription("Timer dequeue messages lag").ofLongs().buildWithCallback(measurement -> {
                TimerMessageStore timerMessageStore = messageStore.getTimerMessageStore();
                measurement.record(timerMessageStore.getDequeueBehindMessages(), this.newAttributesBuilder().build());
            });
            this.timerDequeueLatency = meter.gaugeBuilder("rocketmq_timer_dequeue_latency").setDescription("Timer dequeue latency").setUnit("milliseconds").ofLongs().buildWithCallback(measurement -> {
                TimerMessageStore timerMessageStore = messageStore.getTimerMessageStore();
                measurement.record(timerMessageStore.getDequeueBehindMillis(), this.newAttributesBuilder().build());
            });
            this.timingMessages = meter.gaugeBuilder("rocketmq_timing_messages").setDescription("Current message number in timing").ofLongs().buildWithCallback(measurement -> {
                TimerMessageStore timerMessageStore = messageStore.getTimerMessageStore();
                timerMessageStore.getTimerMetrics().getTimingCount().forEach((topic, metric) -> measurement.record(metric.getCount().get(), this.newAttributesBuilder().put("topic", topic).build()));
            });
            this.timerDequeueTotal = meter.counterBuilder("rocketmq_timer_dequeue_total").setDescription("Total number of timer dequeue").build();
            this.timerEnqueueTotal = meter.counterBuilder("rocketmq_timer_enqueue_total").setDescription("Total number of timer enqueue").build();
            this.timerMessageSnapshot = meter.gaugeBuilder("rocketmq_timer_message_snapshot").setDescription("Timer message distribution snapshot, only count timing messages in 24h.").ofLongs().buildWithCallback(measurement -> {
                TimerMetrics timerMetrics = messageStore.getTimerMessageStore().getTimerMetrics();
                TimerWheel timerWheel = messageStore.getTimerMessageStore().getTimerWheel();
                int precisionMs = this.messageStoreConfig.getTimerPrecisionMs();
                List<Integer> timerDist = timerMetrics.getTimerDistList();
                long currTime = System.currentTimeMillis() / (long)precisionMs * (long)precisionMs;
                for (int i = 0; i < timerDist.size(); ++i) {
                    int slotBeforeNum = i == 0 ? 0 : timerDist.get(i - 1) * 1000 / precisionMs;
                    int slotTotalNum = timerDist.get(i) * 1000 / precisionMs;
                    int periodTotal = 0;
                    for (int j = slotBeforeNum; j < slotTotalNum; ++j) {
                        Slot slotEach = timerWheel.getSlot(currTime + (long)j * (long)precisionMs);
                        periodTotal += slotEach.num;
                    }
                    measurement.record((long)periodTotal, this.newAttributesBuilder().put("timer_bound_s", timerDist.get(i).toString()).build());
                }
            });
            this.timerMessageSetLatency = meter.histogramBuilder("rocketmq_delay_message_latency").setDescription("Timer message set latency distribution").setUnit("seconds").ofLongs().build();
        }
    }

    public void incTimerDequeueCount(String topic) {
        this.timerDequeueTotal.add(1L, this.newAttributesBuilder().put("topic", topic).build());
    }

    public void incTimerEnqueueCount(String topic) {
        AttributesBuilder attributesBuilder = this.newAttributesBuilder();
        if (topic != null) {
            attributesBuilder.put("topic", topic);
        }
        this.timerEnqueueTotal.add(1L, attributesBuilder.build());
    }

    public AttributesBuilder newAttributesBuilder() {
        if (this.attributesBuilderSupplier == null) {
            return Attributes.builder();
        }
        return this.attributesBuilderSupplier.get().put("storage_type", "local").put("storage_medium", "disk");
    }

    public Supplier<AttributesBuilder> getAttributesBuilderSupplier() {
        return this.attributesBuilderSupplier;
    }

    public MessageStoreConfig getMessageStoreConfig() {
        return this.messageStoreConfig;
    }

    public ObservableLongGauge getStorageSize() {
        return this.storageSize;
    }

    public ObservableLongGauge getFlushBehind() {
        return this.flushBehind;
    }

    public ObservableLongGauge getDispatchBehind() {
        return this.dispatchBehind;
    }

    public ObservableLongGauge getMessageReserveTime() {
        return this.messageReserveTime;
    }

    public ObservableLongGauge getTimerEnqueueLag() {
        return this.timerEnqueueLag;
    }

    public ObservableLongGauge getTimerEnqueueLatency() {
        return this.timerEnqueueLatency;
    }

    public ObservableLongGauge getTimerDequeueLag() {
        return this.timerDequeueLag;
    }

    public ObservableLongGauge getTimerDequeueLatency() {
        return this.timerDequeueLatency;
    }

    public ObservableLongGauge getTimingMessages() {
        return this.timingMessages;
    }

    public LongCounter getTimerDequeueTotal() {
        return this.timerDequeueTotal;
    }

    public LongCounter getTimerEnqueueTotal() {
        return this.timerEnqueueTotal;
    }

    public ObservableLongGauge getTimerMessageSnapshot() {
        return this.timerMessageSnapshot;
    }

    public LongHistogram getTimerMessageSetLatency() {
        return this.timerMessageSetLatency;
    }

    public void setAttributesBuilderSupplier(Supplier<AttributesBuilder> attributesBuilderSupplier) {
        this.attributesBuilderSupplier = attributesBuilderSupplier;
    }

    public RocksDBStoreMetricsManager getRocksDBStoreMetricsManager() {
        return this.rocksDBStoreMetricsManager;
    }
}

