/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.rocksdb;

import java.util.function.LongSupplier;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.rocksdb.AbstractCompactionFilter;
import org.rocksdb.AbstractCompactionFilterFactory;
import org.rocksdb.RemoveConsumeQueueCompactionFilter;

public class ConsumeQueueCompactionFilterFactory
extends AbstractCompactionFilterFactory<RemoveConsumeQueueCompactionFilter> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqRocksDB");
    private final LongSupplier minPhyOffsetSupplier;

    public ConsumeQueueCompactionFilterFactory(LongSupplier minPhyOffsetSupplier) {
        this.minPhyOffsetSupplier = minPhyOffsetSupplier;
    }

    public String name() {
        return "ConsumeQueueCompactionFilterFactory";
    }

    public RemoveConsumeQueueCompactionFilter createCompactionFilter(AbstractCompactionFilter.Context context) {
        long minPhyOffset = this.minPhyOffsetSupplier.getAsLong();
        LOGGER.info("manualCompaction minPhyOffset: {}, isFull: {}, isManual: {}", new Object[]{minPhyOffset, context.isFullCompaction(), context.isManualCompaction()});
        return new RemoveConsumeQueueCompactionFilter(minPhyOffset);
    }
}

