/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.auth.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.rocketmq.auth.authentication.model.Subject;
import org.apache.rocketmq.auth.authorization.enums.Decision;
import org.apache.rocketmq.auth.authorization.enums.PolicyType;
import org.apache.rocketmq.auth.authorization.model.Acl;
import org.apache.rocketmq.auth.authorization.model.Environment;
import org.apache.rocketmq.auth.authorization.model.Policy;
import org.apache.rocketmq.auth.authorization.model.PolicyEntry;
import org.apache.rocketmq.auth.authorization.model.Resource;
import org.apache.rocketmq.common.action.Action;
import org.apache.rocketmq.remoting.protocol.body.AclInfo;

public class AclConverter {
    public static Acl convertAcl(AclInfo aclInfo) {
        if (aclInfo == null) {
            return null;
        }
        Subject subject = Subject.of((String)aclInfo.getSubject());
        ArrayList<Policy> policies = new ArrayList<Policy>();
        for (AclInfo.PolicyInfo policy : aclInfo.getPolicies()) {
            PolicyType policyType = PolicyType.getByName((String)policy.getPolicyType());
            List entryInfos = policy.getEntries();
            if (CollectionUtils.isEmpty((Collection)entryInfos)) continue;
            ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
            for (AclInfo.PolicyEntryInfo entryInfo : entryInfos) {
                Resource resource = Resource.of((String)entryInfo.getResource());
                ArrayList<Action> actions = new ArrayList<Action>();
                for (String a : entryInfo.getActions()) {
                    Action action = Action.getByName((String)a);
                    if (action == null) continue;
                    actions.add(action);
                }
                Environment environment = new Environment();
                if (CollectionUtils.isNotEmpty((Collection)entryInfo.getSourceIps())) {
                    environment.setSourceIps(entryInfo.getSourceIps());
                }
                Decision decision = Decision.getByName((String)entryInfo.getDecision());
                entries.add(PolicyEntry.of((Resource)resource, actions, (Environment)environment, (Decision)decision));
            }
            policies.add(Policy.of((PolicyType)policyType, entries));
        }
        return Acl.of((Subject)subject, policies);
    }

    public static List<AclInfo> convertAcls(List<Acl> acls) {
        if (CollectionUtils.isEmpty(acls)) {
            return null;
        }
        return acls.stream().map(AclConverter::convertAcl).collect(Collectors.toList());
    }

    public static AclInfo convertAcl(Acl acl) {
        if (acl == null) {
            return null;
        }
        AclInfo aclInfo = new AclInfo();
        aclInfo.setSubject(acl.getSubject().getSubjectKey());
        if (CollectionUtils.isEmpty((Collection)acl.getPolicies())) {
            return aclInfo;
        }
        List policyInfos = acl.getPolicies().stream().map(AclConverter::convertPolicy).collect(Collectors.toList());
        aclInfo.setPolicies(policyInfos);
        return aclInfo;
    }

    private static AclInfo.PolicyInfo convertPolicy(Policy policy) {
        AclInfo.PolicyInfo policyInfo = new AclInfo.PolicyInfo();
        if (policy.getPolicyType() != null) {
            policyInfo.setPolicyType(policy.getPolicyType().getName());
        }
        if (CollectionUtils.isEmpty((Collection)policy.getEntries())) {
            return policyInfo;
        }
        List entryInfos = policy.getEntries().stream().map(AclConverter::convertPolicyEntry).collect(Collectors.toList());
        policyInfo.setEntries(entryInfos);
        return policyInfo;
    }

    private static AclInfo.PolicyEntryInfo convertPolicyEntry(PolicyEntry entry) {
        AclInfo.PolicyEntryInfo entryInfo = new AclInfo.PolicyEntryInfo();
        entryInfo.setResource(entry.toResourceStr());
        entryInfo.setActions(entry.toActionsStr());
        if (entry.getEnvironment() != null) {
            entryInfo.setSourceIps(entry.getEnvironment().getSourceIps());
        }
        entryInfo.setDecision(entry.getDecision().getName());
        return entryInfo;
    }
}

