/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.metrics;

import com.google.common.base.Splitter;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import io.opentelemetry.exporter.logging.otlp.OtlpJsonLoggingMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServer;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.ViewBuilder;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import io.opentelemetry.sdk.metrics.internal.SdkMeterProviderUtil;
import io.opentelemetry.sdk.resources.Resource;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.client.ConsumerManager;
import org.apache.rocketmq.broker.metrics.ConsumerAttr;
import org.apache.rocketmq.broker.metrics.ConsumerLagCalculator;
import org.apache.rocketmq.broker.metrics.PopMetricsManager;
import org.apache.rocketmq.broker.metrics.ProducerAttr;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.attribute.TopicMessageType;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.metrics.MetricsExporterType;
import org.apache.rocketmq.common.metrics.NopLongCounter;
import org.apache.rocketmq.common.metrics.NopLongHistogram;
import org.apache.rocketmq.common.metrics.NopObservableLongGauge;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.metrics.RemotingMetricsManager;
import org.apache.rocketmq.remoting.protocol.header.SendMessageRequestHeader;
import org.apache.rocketmq.store.MessageStore;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class BrokerMetricsManager {
    private static final org.apache.rocketmq.logging.org.slf4j.Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final BrokerConfig brokerConfig;
    private final MessageStore messageStore;
    private final BrokerController brokerController;
    private final ConsumerLagCalculator consumerLagCalculator;
    private final Map<String, String> labelMap = new HashMap<String, String>();
    private OtlpGrpcMetricExporter metricExporter;
    private PeriodicMetricReader periodicMetricReader;
    private PrometheusHttpServer prometheusHttpServer;
    private MetricExporter loggingMetricExporter;
    private Meter brokerMeter;
    private Supplier<AttributesBuilder> attributesBuilderSupplier = Attributes::builder;
    private ObservableLongGauge processorWatermark = new NopObservableLongGauge();
    private ObservableLongGauge brokerPermission = new NopObservableLongGauge();
    private ObservableLongGauge topicNum = new NopObservableLongGauge();
    private ObservableLongGauge consumerGroupNum = new NopObservableLongGauge();
    private LongCounter messagesInTotal = new NopLongCounter();
    private LongCounter messagesOutTotal = new NopLongCounter();
    private LongCounter throughputInTotal = new NopLongCounter();
    private LongCounter throughputOutTotal = new NopLongCounter();
    private LongHistogram messageSize = new NopLongHistogram();
    private LongHistogram topicCreateExecuteTime = new NopLongHistogram();
    private LongHistogram consumerGroupCreateExecuteTime = new NopLongHistogram();
    private ObservableLongGauge producerConnection = new NopObservableLongGauge();
    private ObservableLongGauge consumerConnection = new NopObservableLongGauge();
    private ObservableLongGauge consumerLagMessages = new NopObservableLongGauge();
    private ObservableLongGauge consumerLagLatency = new NopObservableLongGauge();
    private ObservableLongGauge consumerInflightMessages = new NopObservableLongGauge();
    private ObservableLongGauge consumerQueueingLatency = new NopObservableLongGauge();
    private ObservableLongGauge consumerReadyMessages = new NopObservableLongGauge();
    private LongCounter sendToDlqMessages = new NopLongCounter();
    private ObservableLongGauge halfMessages = new NopObservableLongGauge();
    private LongCounter commitMessagesTotal = new NopLongCounter();
    private LongCounter rollBackMessagesTotal = new NopLongCounter();
    private LongHistogram transactionFinishLatency = new NopLongHistogram();
    private final RemotingMetricsManager remotingMetricsManager;
    private final PopMetricsManager popMetricsManager;
    public static final List<String> SYSTEM_GROUP_PREFIX_LIST = new ArrayList<String>(){
        {
            this.add("CID_RMQ_SYS_".toLowerCase());
        }
    };

    public BrokerMetricsManager(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.brokerConfig = brokerController.getBrokerConfig();
        this.messageStore = brokerController.getMessageStore();
        this.consumerLagCalculator = new ConsumerLagCalculator(brokerController);
        this.remotingMetricsManager = new RemotingMetricsManager();
        this.popMetricsManager = new PopMetricsManager();
        this.init();
    }

    public AttributesBuilder newAttributesBuilder() {
        if (this.attributesBuilderSupplier == null) {
            this.attributesBuilderSupplier = Attributes::builder;
        }
        AttributesBuilder attributesBuilder = this.attributesBuilderSupplier.get();
        this.labelMap.forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        return attributesBuilder;
    }

    private Attributes buildLagAttributes(ConsumerLagCalculator.BaseCalculateResult result) {
        AttributesBuilder attributesBuilder = this.newAttributesBuilder();
        attributesBuilder.put("consumer_group", result.group);
        attributesBuilder.put("topic", result.topic);
        attributesBuilder.put("is_retry", result.isRetry);
        attributesBuilder.put("is_system", BrokerMetricsManager.isSystem(result.topic, result.group));
        return attributesBuilder.build();
    }

    public static boolean isRetryOrDlqTopic(String topic) {
        if (StringUtils.isBlank((CharSequence)topic)) {
            return false;
        }
        return topic.startsWith("%RETRY%") || topic.startsWith("%DLQ%");
    }

    public static boolean isSystemGroup(String group) {
        if (StringUtils.isBlank((CharSequence)group)) {
            return false;
        }
        String groupInLowerCase = group.toLowerCase();
        for (String prefix : SYSTEM_GROUP_PREFIX_LIST) {
            if (!groupInLowerCase.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSystem(String topic, String group) {
        return TopicValidator.isSystemTopic((String)topic) || BrokerMetricsManager.isSystemGroup(group);
    }

    public static TopicMessageType getMessageType(SendMessageRequestHeader requestHeader) {
        Map properties = MessageDecoder.string2messageProperties((String)requestHeader.getProperties());
        String traFlag = (String)properties.get("TRAN_MSG");
        TopicMessageType topicMessageType = TopicMessageType.NORMAL;
        if (Boolean.parseBoolean(traFlag)) {
            topicMessageType = TopicMessageType.TRANSACTION;
        } else if (properties.containsKey("__SHARDINGKEY")) {
            topicMessageType = TopicMessageType.FIFO;
        } else if (properties.get("__STARTDELIVERTIME") != null || properties.get("DELAY") != null || properties.get("TIMER_DELIVER_MS") != null || properties.get("TIMER_DELAY_SEC") != null || properties.get("TIMER_DELAY_MS") != null) {
            topicMessageType = TopicMessageType.DELAY;
        }
        return topicMessageType;
    }

    public Meter getBrokerMeter() {
        return this.brokerMeter;
    }

    public LongCounter getMessagesInTotal() {
        return this.messagesInTotal;
    }

    public LongCounter getMessagesOutTotal() {
        return this.messagesOutTotal;
    }

    public LongCounter getThroughputInTotal() {
        return this.throughputInTotal;
    }

    public LongCounter getThroughputOutTotal() {
        return this.throughputOutTotal;
    }

    public LongHistogram getMessageSize() {
        return this.messageSize;
    }

    public LongCounter getSendToDlqMessages() {
        return this.sendToDlqMessages;
    }

    public LongCounter getCommitMessagesTotal() {
        return this.commitMessagesTotal;
    }

    public LongCounter getRollBackMessagesTotal() {
        return this.rollBackMessagesTotal;
    }

    public LongHistogram getTransactionFinishLatency() {
        return this.transactionFinishLatency;
    }

    public LongHistogram getTopicCreateExecuteTime() {
        return this.topicCreateExecuteTime;
    }

    public LongHistogram getConsumerGroupCreateExecuteTime() {
        return this.consumerGroupCreateExecuteTime;
    }

    public void setAttributesBuilderSupplier(Supplier<AttributesBuilder> attributesBuilderSupplier) {
        this.attributesBuilderSupplier = attributesBuilderSupplier;
    }

    private boolean checkConfig() {
        if (this.brokerConfig == null) {
            return false;
        }
        MetricsExporterType exporterType = this.brokerConfig.getMetricsExporterType();
        if (!exporterType.isEnable()) {
            return false;
        }
        switch (exporterType) {
            case OTLP_GRPC: {
                return StringUtils.isNotBlank((CharSequence)this.brokerConfig.getMetricsGrpcExporterTarget());
            }
            case PROM: {
                return true;
            }
            case LOG: {
                return true;
            }
        }
        return false;
    }

    private void init() {
        MetricsExporterType metricsExporterType = this.brokerConfig.getMetricsExporterType();
        if (metricsExporterType == MetricsExporterType.DISABLE) {
            return;
        }
        if (!this.checkConfig()) {
            LOGGER.error("check metrics config failed, will not export metrics");
            return;
        }
        String labels = this.brokerConfig.getMetricsLabel();
        if (StringUtils.isNotBlank((CharSequence)labels)) {
            List kvPairs = Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)labels);
            for (String item : kvPairs) {
                String[] split = item.split(":");
                if (split.length != 2) {
                    LOGGER.warn("metricsLabel is not valid: {}", (Object)labels);
                    continue;
                }
                this.labelMap.put(split[0], split[1]);
            }
        }
        if (this.brokerConfig.isMetricsInDelta()) {
            this.labelMap.put("aggregation", "delta");
        }
        this.labelMap.put("node_type", "broker");
        this.labelMap.put("cluster", this.brokerConfig.getBrokerClusterName());
        this.labelMap.put("node_id", this.brokerConfig.getBrokerName());
        SdkMeterProviderBuilder providerBuilder = SdkMeterProvider.builder().setResource(Resource.empty());
        if (metricsExporterType == MetricsExporterType.OTLP_GRPC) {
            String endpoint = this.brokerConfig.getMetricsGrpcExporterTarget();
            if (!endpoint.startsWith("http")) {
                endpoint = "https://" + endpoint;
            }
            OtlpGrpcMetricExporterBuilder metricExporterBuilder = OtlpGrpcMetricExporter.builder().setEndpoint(endpoint).setTimeout(this.brokerConfig.getMetricGrpcExporterTimeOutInMills(), TimeUnit.MILLISECONDS).setAggregationTemporalitySelector(type -> {
                if (this.brokerConfig.isMetricsInDelta() && (type == InstrumentType.COUNTER || type == InstrumentType.OBSERVABLE_COUNTER || type == InstrumentType.HISTOGRAM)) {
                    return AggregationTemporality.DELTA;
                }
                return AggregationTemporality.CUMULATIVE;
            });
            String headers = this.brokerConfig.getMetricsGrpcExporterHeader();
            if (StringUtils.isNotBlank((CharSequence)headers)) {
                HashMap<String, String> headerMap = new HashMap<String, String>();
                List kvPairs = Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)headers);
                for (String item : kvPairs) {
                    String[] split = item.split(":");
                    if (split.length != 2) {
                        LOGGER.warn("metricsGrpcExporterHeader is not valid: {}", (Object)headers);
                        continue;
                    }
                    headerMap.put(split[0], split[1]);
                }
                headerMap.forEach((arg_0, arg_1) -> ((OtlpGrpcMetricExporterBuilder)metricExporterBuilder).addHeader(arg_0, arg_1));
            }
            this.metricExporter = metricExporterBuilder.build();
            this.periodicMetricReader = PeriodicMetricReader.builder((MetricExporter)this.metricExporter).setInterval(this.brokerConfig.getMetricGrpcExporterIntervalInMills(), TimeUnit.MILLISECONDS).build();
            providerBuilder.registerMetricReader((MetricReader)this.periodicMetricReader);
        }
        if (metricsExporterType == MetricsExporterType.PROM) {
            String promExporterHost = this.brokerConfig.getMetricsPromExporterHost();
            if (StringUtils.isBlank((CharSequence)promExporterHost)) {
                promExporterHost = this.brokerConfig.getBrokerIP1();
            }
            this.prometheusHttpServer = PrometheusHttpServer.builder().setHost(promExporterHost).setPort(this.brokerConfig.getMetricsPromExporterPort()).build();
            providerBuilder.registerMetricReader((MetricReader)this.prometheusHttpServer);
        }
        if (metricsExporterType == MetricsExporterType.LOG) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
            this.loggingMetricExporter = OtlpJsonLoggingMetricExporter.create((AggregationTemporality)(this.brokerConfig.isMetricsInDelta() ? AggregationTemporality.DELTA : AggregationTemporality.CUMULATIVE));
            Logger.getLogger(OtlpJsonLoggingMetricExporter.class.getName()).setLevel(Level.FINEST);
            this.periodicMetricReader = PeriodicMetricReader.builder((MetricExporter)this.loggingMetricExporter).setInterval(this.brokerConfig.getMetricLoggingExporterIntervalInMills(), TimeUnit.MILLISECONDS).build();
            providerBuilder.registerMetricReader((MetricReader)this.periodicMetricReader);
        }
        this.registerMetricsView(providerBuilder);
        this.brokerMeter = OpenTelemetrySdk.builder().setMeterProvider(providerBuilder.build()).build().getMeter("broker-meter");
        this.initStatsMetrics();
        this.initRequestMetrics();
        this.initConnectionMetrics();
        this.initLagAndDlqMetrics();
        this.initTransactionMetrics();
        this.initOtherMetrics();
    }

    private void registerMetricsView(SdkMeterProviderBuilder providerBuilder) {
        ViewBuilder viewBuilder;
        List<Double> messageSizeBuckets = Arrays.asList(1024.0, 4096.0, 524288.0, 1048576.0, 2097152.0, 4194304.0);
        List<Double> commitLatencyBuckets = Arrays.asList(5.0, 60.0, 600.0, 3600.0, 43200.0, 86400.0);
        List<Double> createTimeBuckets = Arrays.asList(Duration.ofMillis(10L).toMillis(), Duration.ofMillis(100L).toMillis(), Duration.ofSeconds(1L).toMillis(), Duration.ofSeconds(3L).toMillis(), Duration.ofSeconds(5L).toMillis());
        InstrumentSelector messageSizeSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_message_size").build();
        ViewBuilder messageSizeViewBuilder = View.builder().setAggregation(Aggregation.explicitBucketHistogram(messageSizeBuckets));
        SdkMeterProviderUtil.setCardinalityLimit((ViewBuilder)messageSizeViewBuilder, (int)this.brokerConfig.getMetricsOtelCardinalityLimit());
        providerBuilder.registerView(messageSizeSelector, messageSizeViewBuilder.build());
        InstrumentSelector commitLatencySelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_finish_message_latency").build();
        ViewBuilder commitLatencyViewBuilder = View.builder().setAggregation(Aggregation.explicitBucketHistogram(commitLatencyBuckets));
        SdkMeterProviderUtil.setCardinalityLimit((ViewBuilder)commitLatencyViewBuilder, (int)this.brokerConfig.getMetricsOtelCardinalityLimit());
        providerBuilder.registerView(commitLatencySelector, commitLatencyViewBuilder.build());
        InstrumentSelector createTopicTimeSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_topic_create_execution_time").build();
        InstrumentSelector createSubGroupTimeSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_consumer_group_create_execution_time").build();
        ViewBuilder createTopicTimeViewBuilder = View.builder().setAggregation(Aggregation.explicitBucketHistogram(createTimeBuckets));
        ViewBuilder createSubGroupTimeViewBuilder = View.builder().setAggregation(Aggregation.explicitBucketHistogram(createTimeBuckets));
        SdkMeterProviderUtil.setCardinalityLimit((ViewBuilder)createTopicTimeViewBuilder, (int)this.brokerConfig.getMetricsOtelCardinalityLimit());
        providerBuilder.registerView(createTopicTimeSelector, createTopicTimeViewBuilder.build());
        SdkMeterProviderUtil.setCardinalityLimit((ViewBuilder)createSubGroupTimeViewBuilder, (int)this.brokerConfig.getMetricsOtelCardinalityLimit());
        providerBuilder.registerView(createSubGroupTimeSelector, createSubGroupTimeViewBuilder.build());
        for (Pair pair : this.remotingMetricsManager.getMetricsView()) {
            viewBuilder = (ViewBuilder)pair.getObject2();
            SdkMeterProviderUtil.setCardinalityLimit((ViewBuilder)viewBuilder, (int)this.brokerConfig.getMetricsOtelCardinalityLimit());
            providerBuilder.registerView((InstrumentSelector)pair.getObject1(), viewBuilder.build());
        }
        for (Pair pair : this.messageStore.getMetricsView()) {
            viewBuilder = (ViewBuilder)pair.getObject2();
            SdkMeterProviderUtil.setCardinalityLimit((ViewBuilder)viewBuilder, (int)this.brokerConfig.getMetricsOtelCardinalityLimit());
            providerBuilder.registerView((InstrumentSelector)pair.getObject1(), viewBuilder.build());
        }
        for (Pair pair : this.popMetricsManager.getMetricsView()) {
            viewBuilder = (ViewBuilder)pair.getObject2();
            SdkMeterProviderUtil.setCardinalityLimit((ViewBuilder)viewBuilder, (int)this.brokerConfig.getMetricsOtelCardinalityLimit());
            providerBuilder.registerView((InstrumentSelector)pair.getObject1(), viewBuilder.build());
        }
        InstrumentSelector defaultCounterSelector = InstrumentSelector.builder().setType(InstrumentType.COUNTER).build();
        ViewBuilder viewBuilder2 = View.builder().setDescription("default view for counter.");
        SdkMeterProviderUtil.setCardinalityLimit((ViewBuilder)viewBuilder2, (int)this.brokerConfig.getMetricsOtelCardinalityLimit());
        providerBuilder.registerView(defaultCounterSelector, viewBuilder2.build());
        InstrumentSelector defaultGaugeSelector = InstrumentSelector.builder().setType(InstrumentType.OBSERVABLE_GAUGE).build();
        ViewBuilder defaultGaugeViewBuilder = View.builder().setDescription("default view for gauge.");
        SdkMeterProviderUtil.setCardinalityLimit((ViewBuilder)defaultGaugeViewBuilder, (int)this.brokerConfig.getMetricsOtelCardinalityLimit());
        providerBuilder.registerView(defaultGaugeSelector, defaultGaugeViewBuilder.build());
    }

    private void initStatsMetrics() {
        if (!this.brokerConfig.isEnableStatsMetrics()) {
            return;
        }
        this.processorWatermark = this.brokerMeter.gaugeBuilder("rocketmq_processor_watermark").setDescription("Request processor watermark").ofLongs().buildWithCallback(measurement -> {
            measurement.record((long)this.brokerController.getSendThreadPoolQueue().size(), this.newAttributesBuilder().put("processor", "send").build());
            measurement.record((long)this.brokerController.getAsyncPutThreadPoolQueue().size(), this.newAttributesBuilder().put("processor", "async_put").build());
            measurement.record((long)this.brokerController.getPullThreadPoolQueue().size(), this.newAttributesBuilder().put("processor", "pull").build());
            measurement.record((long)this.brokerController.getAckThreadPoolQueue().size(), this.newAttributesBuilder().put("processor", "ack").build());
            measurement.record((long)this.brokerController.getQueryThreadPoolQueue().size(), this.newAttributesBuilder().put("processor", "query_message").build());
            measurement.record((long)this.brokerController.getClientManagerThreadPoolQueue().size(), this.newAttributesBuilder().put("processor", "client_manager").build());
            measurement.record((long)this.brokerController.getHeartbeatThreadPoolQueue().size(), this.newAttributesBuilder().put("processor", "heartbeat").build());
            measurement.record((long)this.brokerController.getLitePullThreadPoolQueue().size(), this.newAttributesBuilder().put("processor", "lite_pull").build());
            measurement.record((long)this.brokerController.getEndTransactionThreadPoolQueue().size(), this.newAttributesBuilder().put("processor", "transaction").build());
            measurement.record((long)this.brokerController.getConsumerManagerThreadPoolQueue().size(), this.newAttributesBuilder().put("processor", "consumer_manager").build());
            measurement.record((long)this.brokerController.getAdminBrokerThreadPoolQueue().size(), this.newAttributesBuilder().put("processor", "admin").build());
            measurement.record((long)this.brokerController.getReplyThreadPoolQueue().size(), this.newAttributesBuilder().put("processor", "reply").build());
        });
        this.brokerPermission = this.brokerMeter.gaugeBuilder("rocketmq_broker_permission").setDescription("Broker permission").ofLongs().buildWithCallback(measurement -> measurement.record((long)this.brokerConfig.getBrokerPermission(), this.newAttributesBuilder().build()));
        this.topicNum = this.brokerMeter.gaugeBuilder("rocketmq_topic_number").setDescription("Active topic number").ofLongs().buildWithCallback(measurement -> measurement.record((long)this.brokerController.getTopicConfigManager().getTopicConfigTable().size(), this.newAttributesBuilder().build()));
        this.consumerGroupNum = this.brokerMeter.gaugeBuilder("rocketmq_consumer_group_number").setDescription("Active subscription group number").ofLongs().buildWithCallback(measurement -> measurement.record((long)this.brokerController.getSubscriptionGroupManager().getSubscriptionGroupTable().size(), this.newAttributesBuilder().build()));
    }

    private void initRequestMetrics() {
        if (!this.brokerConfig.isEnableRequestMetrics()) {
            return;
        }
        this.messagesInTotal = this.brokerMeter.counterBuilder("rocketmq_messages_in_total").setDescription("Total number of incoming messages").build();
        this.messagesOutTotal = this.brokerMeter.counterBuilder("rocketmq_messages_out_total").setDescription("Total number of outgoing messages").build();
        this.throughputInTotal = this.brokerMeter.counterBuilder("rocketmq_throughput_in_total").setDescription("Total traffic of incoming messages").build();
        this.throughputOutTotal = this.brokerMeter.counterBuilder("rocketmq_throughput_out_total").setDescription("Total traffic of outgoing messages").build();
        this.messageSize = this.brokerMeter.histogramBuilder("rocketmq_message_size").setDescription("Incoming messages size").ofLongs().build();
        this.topicCreateExecuteTime = this.brokerMeter.histogramBuilder("rocketmq_topic_create_execution_time").setDescription("The distribution of create topic time").ofLongs().setUnit("milliseconds").build();
        this.consumerGroupCreateExecuteTime = this.brokerMeter.histogramBuilder("rocketmq_consumer_group_create_execution_time").setDescription("The distribution of create subscription time").ofLongs().setUnit("milliseconds").build();
    }

    private void initConnectionMetrics() {
        if (!this.brokerConfig.isEnableConnectionMetrics()) {
            return;
        }
        this.producerConnection = this.brokerMeter.gaugeBuilder("rocketmq_producer_connections").setDescription("Producer connections").ofLongs().buildWithCallback(measurement -> {
            HashMap<ProducerAttr, Integer> metricsMap = new HashMap<ProducerAttr, Integer>();
            this.brokerController.getProducerManager().getGroupChannelTable().values().stream().flatMap(map -> map.values().stream()).forEach(info -> {
                ProducerAttr attr = new ProducerAttr(info.getLanguage(), info.getVersion());
                Integer count = metricsMap.computeIfAbsent(attr, k -> 0);
                metricsMap.put(attr, count + 1);
            });
            metricsMap.forEach((attr, count) -> {
                Attributes attributes = this.newAttributesBuilder().put("language", attr.language.name().toLowerCase()).put("version", MQVersion.getVersionDesc((int)attr.version).toLowerCase()).put("protocol_type", "remoting").build();
                measurement.record((long)count.intValue(), attributes);
            });
        });
        this.consumerConnection = this.brokerMeter.gaugeBuilder("rocketmq_consumer_connections").setDescription("Consumer connections").ofLongs().buildWithCallback(measurement -> {
            HashMap<ConsumerAttr, Integer> metricsMap = new HashMap<ConsumerAttr, Integer>();
            ConsumerManager consumerManager = this.brokerController.getConsumerManager();
            consumerManager.getConsumerTable().forEach((group, groupInfo) -> {
                if (groupInfo != null) {
                    groupInfo.getChannelInfoTable().values().forEach(info -> {
                        ConsumerAttr attr = new ConsumerAttr((String)group, info.getLanguage(), info.getVersion(), groupInfo.getConsumeType());
                        Integer count = metricsMap.computeIfAbsent(attr, k -> 0);
                        metricsMap.put(attr, count + 1);
                    });
                }
            });
            metricsMap.forEach((attr, count) -> {
                Attributes attributes = this.newAttributesBuilder().put("consumer_group", attr.group).put("language", attr.language.name().toLowerCase()).put("version", MQVersion.getVersionDesc((int)attr.version).toLowerCase()).put("consume_mode", attr.consumeMode.getTypeCN().toLowerCase()).put("protocol_type", "remoting").put("is_system", BrokerMetricsManager.isSystemGroup(attr.group)).build();
                measurement.record((long)count.intValue(), attributes);
            });
        });
    }

    private void initLagAndDlqMetrics() {
        if (!this.brokerConfig.isEnableLagAndDlqMetrics()) {
            return;
        }
        this.consumerLagMessages = this.brokerMeter.gaugeBuilder("rocketmq_consumer_lag_messages").setDescription("Consumer lag messages").ofLongs().buildWithCallback(measurement -> this.consumerLagCalculator.calculateLag(result -> measurement.record(result.lag, this.buildLagAttributes((ConsumerLagCalculator.BaseCalculateResult)result))));
        this.consumerLagLatency = this.brokerMeter.gaugeBuilder("rocketmq_consumer_lag_latency").setDescription("Consumer lag time").setUnit("milliseconds").ofLongs().buildWithCallback(measurement -> this.consumerLagCalculator.calculateLag(result -> {
            long latency = 0L;
            long curTimeStamp = System.currentTimeMillis();
            if (result.earliestUnconsumedTimestamp != 0L) {
                latency = curTimeStamp - result.earliestUnconsumedTimestamp;
            }
            measurement.record(latency, this.buildLagAttributes((ConsumerLagCalculator.BaseCalculateResult)result));
        }));
        this.consumerInflightMessages = this.brokerMeter.gaugeBuilder("rocketmq_consumer_inflight_messages").setDescription("Consumer inflight messages").ofLongs().buildWithCallback(measurement -> this.consumerLagCalculator.calculateInflight(result -> measurement.record(result.inFlight, this.buildLagAttributes((ConsumerLagCalculator.BaseCalculateResult)result))));
        this.consumerQueueingLatency = this.brokerMeter.gaugeBuilder("rocketmq_consumer_queueing_latency").setDescription("Consumer queueing time").setUnit("milliseconds").ofLongs().buildWithCallback(measurement -> this.consumerLagCalculator.calculateInflight(result -> {
            long latency = 0L;
            long curTimeStamp = System.currentTimeMillis();
            if (result.earliestUnPulledTimestamp != 0L) {
                latency = curTimeStamp - result.earliestUnPulledTimestamp;
            }
            measurement.record(latency, this.buildLagAttributes((ConsumerLagCalculator.BaseCalculateResult)result));
        }));
        this.consumerReadyMessages = this.brokerMeter.gaugeBuilder("rocketmq_consumer_ready_messages").setDescription("Consumer ready messages").ofLongs().buildWithCallback(measurement -> this.consumerLagCalculator.calculateAvailable(result -> measurement.record(result.available, this.buildLagAttributes((ConsumerLagCalculator.BaseCalculateResult)result))));
        this.sendToDlqMessages = this.brokerMeter.counterBuilder("rocketmq_send_to_dlq_messages_total").setDescription("Consumer send to DLQ messages").build();
    }

    private void initTransactionMetrics() {
        if (!this.brokerController.getBrokerConfig().isEnableTransactionMetrics()) {
            return;
        }
        this.commitMessagesTotal = this.brokerMeter.counterBuilder("rocketmq_commit_messages_total").setDescription("Total number of commit messages").build();
        this.rollBackMessagesTotal = this.brokerMeter.counterBuilder("rocketmq_rollback_messages_total").setDescription("Total number of rollback messages").build();
        this.transactionFinishLatency = this.brokerMeter.histogramBuilder("rocketmq_finish_message_latency").setDescription("Transaction finish latency").ofLongs().setUnit("ms").build();
        this.halfMessages = this.brokerMeter.gaugeBuilder("rocketmq_half_messages").setDescription("Half messages of all topics").ofLongs().buildWithCallback(measurement -> this.brokerController.getTransactionalMessageService().getTransactionMetrics().getTransactionCounts().forEach((topic, metric) -> measurement.record(metric.getCount().get(), this.newAttributesBuilder().put("topic", topic).build())));
    }

    private void initOtherMetrics() {
        if (this.brokerConfig.isEnableRemotingMetrics()) {
            this.remotingMetricsManager.initMetrics(this.brokerMeter, this::newAttributesBuilder);
        }
        if (this.brokerConfig.isEnableMessageStoreMetrics()) {
            this.messageStore.initMetrics(this.brokerMeter, this::newAttributesBuilder);
        }
        if (this.brokerConfig.isEnablePopMetrics()) {
            this.popMetricsManager.initMetrics(this.brokerMeter, this.brokerController, this::newAttributesBuilder);
        }
    }

    public void shutdown() {
        if (this.brokerConfig.isInBrokerContainer()) {
            if (this.brokerConfig.getMetricsExporterType() == MetricsExporterType.OTLP_GRPC) {
                while (!this.periodicMetricReader.forceFlush().join(60L, TimeUnit.SECONDS).isDone()) {
                }
                while (!this.periodicMetricReader.shutdown().join(60L, TimeUnit.SECONDS).isSuccess()) {
                }
                while (!this.metricExporter.shutdown().join(60L, TimeUnit.SECONDS).isSuccess()) {
                }
            }
            if (this.brokerConfig.getMetricsExporterType() == MetricsExporterType.PROM) {
                while (!this.prometheusHttpServer.forceFlush().join(60L, TimeUnit.SECONDS).isDone()) {
                }
                while (!this.prometheusHttpServer.shutdown().join(60L, TimeUnit.SECONDS).isSuccess()) {
                }
            }
            if (this.brokerConfig.getMetricsExporterType() == MetricsExporterType.LOG) {
                while (!this.periodicMetricReader.forceFlush().join(60L, TimeUnit.SECONDS).isDone()) {
                }
                while (!this.periodicMetricReader.shutdown().join(60L, TimeUnit.SECONDS).isSuccess()) {
                }
                while (!this.loggingMetricExporter.shutdown().join(60L, TimeUnit.SECONDS).isSuccess()) {
                }
            }
        } else {
            if (this.brokerConfig.getMetricsExporterType() == MetricsExporterType.OTLP_GRPC) {
                this.periodicMetricReader.forceFlush();
                this.periodicMetricReader.shutdown();
                this.metricExporter.shutdown();
            }
            if (this.brokerConfig.getMetricsExporterType() == MetricsExporterType.PROM) {
                this.prometheusHttpServer.forceFlush();
                this.prometheusHttpServer.shutdown();
            }
            if (this.brokerConfig.getMetricsExporterType() == MetricsExporterType.LOG) {
                this.periodicMetricReader.forceFlush();
                this.periodicMetricReader.shutdown();
                this.loggingMetricExporter.shutdown();
            }
        }
    }

    public RemotingMetricsManager getRemotingMetricsManager() {
        return this.remotingMetricsManager;
    }

    public PopMetricsManager getPopMetricsManager() {
        return this.popMetricsManager;
    }
}

