/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.projects;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.common.DependencyTypeSet;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.exceptions.CircularDependencyException;
import org.apache.royale.compiler.internal.graph.Graph;
import org.apache.royale.compiler.internal.graph.GraphEdge;
import org.apache.royale.compiler.internal.graph.TopologicalSort;
import org.apache.royale.compiler.internal.units.CompilationUnitBase;
import org.apache.royale.compiler.internal.units.EmbedCompilationUnit;
import org.apache.royale.compiler.internal.units.InvisibleCompilationUnit;
import org.apache.royale.compiler.units.ICompilationUnit;

public final class DependencyGraph {
    private final Graph<ICompilationUnit, Edge> graph = new Graph();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    public CircularDependencyException lastCircularDependencyException;

    private Edge getEdge(ICompilationUnit referencingCompilationUnit, ICompilationUnit declaringCompilationUnit) {
        Edge result = this.graph.getEdge(referencingCompilationUnit, declaringCompilationUnit);
        if (result == null) {
            result = new Edge(referencingCompilationUnit, declaringCompilationUnit);
            this.graph.setEdge(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependency(ICompilationUnit depender, ICompilationUnit dependee, DependencyTypeSet dt, String targetQName) {
        if (depender == dependee) {
            return;
        }
        assert (!dependee.isInvisible()) : "invisible units do not export symbols to the project scope, so nothing should depend one them.";
        assert (!(depender instanceof InvisibleCompilationUnit)) : "depender should only ever be an InvisibleCompilationUnit delegate, never an InvisibleCompilationUnit";
        this.lock.writeLock().lock();
        try {
            Edge e = this.getEdge(depender, dependee);
            e.addDependency(targetQName, dt);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependency(ICompilationUnit depender, ICompilationUnit dependee, DependencyType dt, String targetQName) {
        if (depender == dependee) {
            return;
        }
        assert (!dependee.isInvisible()) : "invisible units do not export symbols to the project scope, so nothing should depend one them.";
        if (depender instanceof InvisibleCompilationUnit) {
            depender = ((InvisibleCompilationUnit)depender).getDelegate();
        }
        this.lock.writeLock().lock();
        try {
            Edge e = this.getEdge(depender, dependee);
            e.addDependency(targetQName, dt);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependency(ICompilationUnit depender, ICompilationUnit dependee, DependencyType dt) {
        if (depender == dependee) {
            return;
        }
        assert (!dependee.isInvisible()) : "invisible units do not export symbols to the project scope, so nothing should depend one them.";
        if (depender instanceof InvisibleCompilationUnit) {
            depender = ((InvisibleCompilationUnit)depender).getDelegate();
        }
        this.lock.writeLock().lock();
        try {
            Edge e = this.getEdge(depender, dependee);
            e.addDependency(dt);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeDependencies(ICompilationUnit cu) {
        Set<Edge> edges = this.getOutgoingEdges(cu);
        for (Edge edge : edges) {
            this.removeDependency(cu, (ICompilationUnit)edge.getTo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDependency(ICompilationUnit depender, ICompilationUnit dependee) {
        if (depender == dependee) {
            return;
        }
        assert (!dependee.isInvisible()) : "invisible units do not export symbols to the project scope, so nothing should depend one them.";
        if (depender instanceof InvisibleCompilationUnit) {
            depender = ((InvisibleCompilationUnit)depender).getDelegate();
        }
        this.lock.writeLock().lock();
        try {
            Edge e = this.getEdge(depender, dependee);
            this.graph.removeEdge(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<ICompilationUnit> topologicalSort(Collection<ICompilationUnit> roots) {
        return this.topologicalSort(roots, new Comparator<ICompilationUnit>(){

            @Override
            public int compare(ICompilationUnit o1, ICompilationUnit o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ICompilationUnit> topologicalSort(Collection<ICompilationUnit> roots, final Comparator<ICompilationUnit> comparator) {
        this.lock.readLock().lock();
        try {
            ArrayList<ICompilationUnit> sortedList;
            block9: {
                this.lastCircularDependencyException = null;
                sortedList = new ArrayList<ICompilationUnit>(this.graph.getVertices().size());
                TopologicalSort.IVisitor<ICompilationUnit, Edge> visitor = new TopologicalSort.IVisitor<ICompilationUnit, Edge>(){

                    @Override
                    public void visit(ICompilationUnit v) {
                        assert (v != null);
                        sortedList.add(v);
                    }

                    @Override
                    public boolean isTopologicalEdge(Edge e) {
                        return e.getIsInheritanceDependency();
                    }

                    @Override
                    public int compare(ICompilationUnit a, ICompilationUnit b) {
                        return comparator.compare(a, b);
                    }
                };
                try {
                    TopologicalSort.sort(this.graph, roots, visitor);
                }
                catch (CircularDependencyException e1) {
                    if ((CompilerDiagnosticsConstants.diagnostics & 0x8000) == 32768) {
                        System.out.println("Circular Dependency Found");
                        ImmutableList<?> nodes = e1.getCircularDependency();
                        for (ICompilationUnit node : nodes) {
                            try {
                                System.out.println(node.getQualifiedNames().toString());
                            }
                            catch (InterruptedException e2) {
                                e2.printStackTrace();
                            }
                        }
                        System.out.println("End of Circular Dependency");
                    }
                    this.lastCircularDependencyException = e1;
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError((Object)"CircularDependencyException");
                }
            }
            ArrayList<ICompilationUnit> arrayList = sortedList;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static Set<ICompilationUnit> computeInvalidationSet(Iterable<ICompilationUnit> roots) {
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>();
        LinkedList<Edge> workList = new LinkedList<Edge>();
        for (ICompilationUnit unit : roots) {
            assert (unit instanceof CompilationUnitBase);
            CompilationUnitBase compilationUnit = (CompilationUnitBase)unit;
            boolean alreadyVisited = !result.add(compilationUnit);
            if (alreadyVisited) continue;
            workList.addAll(compilationUnit.getProject().getDependencyGraph().getIncomingEdges(compilationUnit));
        }
        DependencyTypeSet recursiveInvalidationSet = DependencyTypeSet.of(DependencyType.INHERITANCE, DependencyType.SIGNATURE, DependencyType.NAMESPACE);
        HashSet<Edge> visitedEdges = new HashSet<Edge>();
        while (!workList.isEmpty()) {
            Edge currentEdge = (Edge)workList.pop();
            if (!visitedEdges.add(currentEdge)) continue;
            assert (currentEdge.getFrom() instanceof CompilationUnitBase);
            CompilationUnitBase dependentUnit = (CompilationUnitBase)currentEdge.getFrom();
            result.add(dependentUnit);
            if (!currentEdge.typeInSet(recursiveInvalidationSet)) continue;
            workList.addAll(dependentUnit.getProject().getDependencyGraph().getIncomingEdges(dependentUnit));
        }
        return result;
    }

    public void addCompilationUnit(ICompilationUnit cu) {
        if (cu instanceof InvisibleCompilationUnit) {
            cu = ((InvisibleCompilationUnit)cu).getDelegate();
        }
        this.lock.writeLock().lock();
        try {
            this.graph.addVertex(cu);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addCompilationUnits(Collection<ICompilationUnit> c) {
        Collection transformed = Collections2.transform(c, (Function)new Function<ICompilationUnit, ICompilationUnit>(){

            public ICompilationUnit apply(ICompilationUnit input) {
                if (input instanceof InvisibleCompilationUnit) {
                    return ((InvisibleCompilationUnit)input).getDelegate();
                }
                return input;
            }
        });
        this.lock.writeLock().lock();
        try {
            this.graph.addVertices(transformed);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeCompilationUnit(ICompilationUnit cu) {
        if (cu instanceof InvisibleCompilationUnit) {
            cu = ((InvisibleCompilationUnit)cu).getDelegate();
        }
        this.lock.writeLock().lock();
        try {
            this.graph.removeVertex(cu);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Edge> getOutgoingEdges(ICompilationUnit cu) {
        if (cu instanceof InvisibleCompilationUnit) {
            cu = ((InvisibleCompilationUnit)cu).getDelegate();
        }
        this.lock.readLock().lock();
        try {
            Set<Edge> edges;
            Set<Edge> set = edges = this.graph.getOutgoingEdges(cu);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Edge> getIncomingEdges(ICompilationUnit cu) {
        if (cu instanceof InvisibleCompilationUnit) {
            cu = ((InvisibleCompilationUnit)cu).getDelegate();
        }
        this.lock.readLock().lock();
        try {
            Set<Edge> edges;
            Set<Edge> set = edges = this.graph.getIncomingEdges(cu);
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<ICompilationUnit> getDirectDependencies(ICompilationUnit cu) {
        Set<Edge> outgoingEdges = this.getOutgoingEdges(cu);
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>(outgoingEdges.size());
        for (Edge e : outgoingEdges) {
            result.add((ICompilationUnit)e.getTo());
        }
        return result;
    }

    public Set<ICompilationUnit> getDirectReverseDependencies(ICompilationUnit cu, DependencyTypeSet types) {
        Set<Edge> incomingEdges = this.getIncomingEdges(cu);
        HashSet<ICompilationUnit> result = new HashSet<ICompilationUnit>(incomingEdges.size());
        for (Edge e : incomingEdges) {
            if (!e.typeInSet(types)) continue;
            result.add((ICompilationUnit)e.getFrom());
        }
        return result;
    }

    public void addEmbedCompilationUnit(EmbedCompilationUnit unit) {
        assert (!unit.isInvisible());
        this.lock.writeLock().lock();
        try {
            this.addCompilationUnit(unit);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean contains(ICompilationUnit unit) {
        return this.graph.getVertices().contains(unit);
    }

    public Map<String, DependencyTypeSet> getDependencySet(ICompilationUnit from, ICompilationUnit to) {
        assert (!to.isInvisible()) : "invisible compilation units must not be in the dependency graph";
        return new HashMap<String, DependencyTypeSet>(this.getEdge(from, to).getNamedDependencies());
    }

    public DependencyTypeSet getDependencyTypes(ICompilationUnit from, ICompilationUnit to) {
        assert (!to.isInvisible()) : "invisible compilation units must not be in the dependency graph";
        return DependencyTypeSet.copyOf(this.getEdge(from, to).getAllDependencies());
    }

    public Collection<ICompilationUnit> getCompilationUnits() {
        return this.graph.getVertices();
    }

    static final class Edge
    extends GraphEdge<ICompilationUnit>
    implements Comparable<Edge> {
        private Map<String, DependencyTypeSet> dependencies;
        private DependencyTypeSet dependencySet;

        private Edge(ICompilationUnit referencingCompilationUnit, ICompilationUnit declaringCompilationUnit) {
            super(referencingCompilationUnit, declaringCompilationUnit);
            assert (!(referencingCompilationUnit instanceof InvisibleCompilationUnit)) : "InvisibleCompilationUnit should never have an edge";
            assert (!(declaringCompilationUnit instanceof InvisibleCompilationUnit)) : "InvisibleCompilationUnit should never have an edge";
            this.dependencySet = DependencyTypeSet.noneOf();
            this.dependencies = new HashMap<String, DependencyTypeSet>();
        }

        public boolean getIsInheritanceDependency() {
            return this.dependencySet.contains(DependencyType.INHERITANCE);
        }

        public boolean getIsSignatureDependency() {
            return this.dependencySet.contains(DependencyType.SIGNATURE);
        }

        public boolean getIsNamespaceDependency() {
            return this.dependencySet.contains(DependencyType.NAMESPACE);
        }

        public boolean getIsExpressionDependency() {
            return this.dependencySet.contains(DependencyType.EXPRESSION);
        }

        public boolean typeInSet(DependencyTypeSet set) {
            for (DependencyType t : set) {
                if (!this.dependencySet.contains(t)) continue;
                return true;
            }
            return false;
        }

        private void addDependency(String qname, DependencyTypeSet types) {
            DependencyTypeSet typeSet = this.dependencies.get(qname);
            if (typeSet != null) {
                DependencyTypeSet newTypeSet = DependencyTypeSet.copyOf(typeSet);
                newTypeSet.addAll(types);
                this.dependencies.put(qname, newTypeSet);
            } else {
                this.dependencies.put(qname, DependencyTypeSet.copyOf(types));
            }
            this.dependencySet.addAll(types);
        }

        private void addDependency(String qname, DependencyType type) {
            DependencyTypeSet typeSet = this.dependencies.get(qname);
            if (typeSet != null) {
                DependencyTypeSet newTypeSet = DependencyTypeSet.copyOf(typeSet);
                newTypeSet.add(type);
                this.dependencies.put(qname, newTypeSet);
            } else {
                this.dependencies.put(qname, DependencyTypeSet.of(type));
            }
            this.dependencySet.add(type);
        }

        private void addDependency(DependencyType type) {
            this.dependencySet.add(type);
        }

        public String toString() {
            String result = ((ICompilationUnit)this.getFrom()).getName() + " -> " + ((ICompilationUnit)this.getTo()).getName() + " [ ";
            if (this.getIsInheritanceDependency()) {
                result = result + "inheritance ";
            }
            if (this.getIsSignatureDependency()) {
                result = result + "signature ";
            }
            if (this.getIsNamespaceDependency()) {
                result = result + "namespace ";
            }
            if (this.getIsExpressionDependency()) {
                result = result + "expression ";
            }
            result = result + "]";
            return result;
        }

        public Map<String, DependencyTypeSet> getNamedDependencies() {
            return this.dependencies;
        }

        @Override
        public int compareTo(Edge edge2) {
            int fromCompare = ((ICompilationUnit)this.getFrom()).getName().compareTo(((ICompilationUnit)edge2.getFrom()).getName());
            if (fromCompare == 0) {
                return ((ICompilationUnit)this.getTo()).getName().compareTo(((ICompilationUnit)edge2.getTo()).getName());
            }
            return fromCompare;
        }

        public DependencyTypeSet getAllDependencies() {
            return this.dependencySet;
        }
    }

    public static final class Dependency
    implements Comparable<Dependency> {
        public String qname;
        public DependencyType type;

        public Dependency(String qname, DependencyType type) {
            this.qname = qname;
            this.type = type;
        }

        @Override
        public int compareTo(Dependency o) {
            return this.qname.compareTo(o.qname);
        }

        public boolean equals(Object o) {
            if (o instanceof Dependency) {
                Dependency other = (Dependency)o;
                return other.qname.equals(this.qname);
            }
            return super.equals(o);
        }

        public int hashCode() {
            return this.qname.hashCode();
        }
    }
}

