/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.internal.tree.mxml.MXMLWebServiceOperationArgumentsPropertyNode;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.problems.MXMLEmptyAttributeProblem;
import org.apache.royale.compiler.problems.MXMLRequiredAttributeProblem;
import org.apache.royale.compiler.problems.MXMLSemanticProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.mxml.IMXMLInstanceNode;
import org.apache.royale.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import org.apache.royale.compiler.tree.mxml.IMXMLStringNode;
import org.apache.royale.compiler.tree.mxml.IMXMLWebServiceOperationNode;

class MXMLWebServiceOperationNode
extends MXMLInstanceNode
implements IMXMLWebServiceOperationNode {
    private static final String TAG_REQUEST = "request";
    private static final String TAG_ARGUMENTS = "arguments";
    private String operationName;

    MXMLWebServiceOperationNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLWebServiceOperationID;
    }

    @Override
    public final String getEffectiveID() {
        return null;
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        MXMLSemanticProblem problem;
        IMXMLInstanceNode namePropertyValueNode;
        super.initializationComplete(builder, tag, info);
        IMXMLPropertySpecifierNode namePropertyNode = this.getPropertySpecifierNode("name");
        if (namePropertyNode != null && (namePropertyValueNode = namePropertyNode.getInstanceNode()) instanceof IMXMLStringNode) {
            IMXMLStringNode stringNode = (IMXMLStringNode)namePropertyValueNode;
            this.operationName = stringNode.getValue();
        }
        if (this.operationName == null) {
            problem = new MXMLRequiredAttributeProblem(tag, "name");
            builder.addProblem(problem);
            this.markInvalidForCodeGen();
        } else if (this.operationName.isEmpty()) {
            problem = new MXMLEmptyAttributeProblem(tag.getTagAttributeData("name"));
            builder.addProblem(problem);
            this.markInvalidForCodeGen();
        }
    }

    @Override
    public final String getOperationName() {
        return this.operationName;
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        String childTagShortName = childTag.getShortName();
        if ((TAG_ARGUMENTS.equals(childTagShortName) || TAG_REQUEST.equals(childTagShortName)) && childTag.getURI() != null && childTag.getURI().equals(tag.getURI())) {
            IClassDefinition classOperation;
            RoyaleProject project = builder.getProject();
            IDefinition definitionRequest = project.resolveSpecifier(classOperation = this.getClassReference(project), TAG_ARGUMENTS);
            if (definitionRequest != null) {
                MXMLWebServiceOperationArgumentsPropertyNode argsPropertyNode = new MXMLWebServiceOperationArgumentsPropertyNode(this);
                argsPropertyNode.setDefinition(definitionRequest);
                argsPropertyNode.initializeFromTag(builder, childTag);
                info.addChildNode(argsPropertyNode);
            }
        } else {
            super.processChildTag(builder, tag, childTag, info);
        }
    }
}

