/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.types;

import flash.swf.Action;
import flash.swf.ActionHandler;
import java.util.Arrays;

public class ActionList
extends ActionHandler {
    public static final int sactionLabel = 256;
    public static final int sactionLineRecord = 257;
    public static final int sactionRegisterRecord = 258;
    private int[] offsets;
    private Action[] actions;
    private int size;

    public ActionList() {
        this(false);
    }

    public ActionList(int capacity) {
        this(false, capacity);
    }

    public ActionList(boolean keepOffsets) {
        this(keepOffsets, 10);
    }

    public ActionList(boolean keepOffsets, int capacity) {
        if (keepOffsets) {
            this.offsets = new int[capacity];
        }
        this.actions = new Action[capacity];
        this.size = 0;
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object instanceof ActionList) {
            ActionList actionList = (ActionList)object;
            if (Arrays.equals(actionList.actions, this.actions)) {
                isEqual = true;
            }
        }
        return isEqual;
    }

    public void visitAll(ActionHandler handler) {
        this.visit(handler, 0, this.size - 1);
    }

    public void visit(ActionHandler handler, int startIndex, int endIndex) {
        endIndex = endIndex < 0 ? this.size - 1 : endIndex;
        for (int j = startIndex; j <= endIndex; ++j) {
            Action a = this.actions[j];
            if (a.code != 256 && a.code != 257) {
                if (this.offsets != null) {
                    handler.setActionOffset(this.offsets[j], a);
                } else {
                    handler.setActionOffset(j, a);
                }
            }
            a.visit(handler);
        }
    }

    @Override
    public void setActionOffset(int offset, Action a) {
        this.insert(offset, a);
    }

    public void grow(int capacity) {
        if (this.offsets != null) {
            int[] newoffsets = new int[capacity];
            System.arraycopy(this.offsets, 0, newoffsets, 0, this.size);
            this.offsets = newoffsets;
        }
        Action[] newactions = new Action[capacity];
        System.arraycopy(this.actions, 0, newactions, 0, this.size);
        this.actions = newactions;
    }

    public int size() {
        return this.size;
    }

    public Action getAction(int i) {
        return this.actions[i];
    }

    public int getOffset(int i) {
        return this.offsets[i];
    }

    public void remove(int i) {
        if (this.offsets != null) {
            System.arraycopy(this.offsets, i + 1, this.offsets, i, this.size - i - 1);
        }
        System.arraycopy(this.actions, i + 1, this.actions, i, this.size - i - 1);
        --this.size;
    }

    private int find(int k) {
        if (this.offsets != null) {
            int lo = 0;
            int hi = this.size - 1;
            while (lo <= hi) {
                int i = (lo + hi) / 2;
                int m = this.offsets[i];
                if (k > m) {
                    lo = i + 1;
                    continue;
                }
                if (k < m) {
                    hi = i - 1;
                    continue;
                }
                return i;
            }
            return -(lo + 1);
        }
        return k;
    }

    public void insert(int offset, Action a) {
        int i;
        if (this.size == this.actions.length) {
            this.grow(this.size * 2);
        }
        if (this.size == 0 || this.offsets == null && offset == this.size || this.offsets != null && offset > this.offsets[this.size - 1]) {
            i = this.size;
        } else {
            i = this.find(offset);
            if (i < 0) {
                i = -i - 1;
            } else if (a.code < 256) {
                while (i < this.size && this.offsets[i] == offset) {
                    ++i;
                }
            }
            if (this.offsets != null) {
                System.arraycopy(this.offsets, i, this.offsets, i + 1, this.size - i);
            }
            System.arraycopy(this.actions, i, this.actions, i + 1, this.size - i);
        }
        if (this.offsets != null) {
            this.offsets[i] = offset;
        }
        this.actions[i] = a;
        ++this.size;
    }

    public void append(Action a) {
        int i = this.size;
        if (i == this.actions.length) {
            this.grow(this.size * 2);
        }
        this.actions[i] = a;
        this.size = i + 1;
    }

    public String toString() {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append("ActionList: count = " + this.actions.length);
        stringBuffer.append(", actions = ");
        for (int i = 0; i < this.size; ++i) {
            stringBuffer.append(this.actions[i]);
        }
        return stringBuffer.toString();
    }

    public int indexOf(int actionCode, int startAt) {
        int at = -1;
        for (int i = startAt; at < 0 && i < this.actions.length; ++i) {
            Action a = this.getAction(i);
            if (a == null || a.code != actionCode) continue;
            at = i;
        }
        return at;
    }

    public int lastIndexOf(int actionCode, int startAt) {
        int at = -1;
        for (int i = startAt; at < 0 && i >= 0; --i) {
            Action a = this.getAction(i);
            if (a == null || a.code != actionCode) continue;
            at = i;
        }
        return at;
    }

    public int indexOf(int actionCode) {
        return this.indexOf(actionCode, 0);
    }

    public int lastIndexOf(int actionCode) {
        return this.lastIndexOf(actionCode, this.actions.length - 1);
    }

    public void setAction(int i, Action action) {
        this.actions[i] = action;
    }
}

