/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.launcher.contexts;

import java.io.IOException;
import org.apache.royale.test.ant.LoggingUtil;
import org.apache.royale.test.ant.launcher.commands.headless.XvncException;
import org.apache.royale.test.ant.launcher.commands.headless.XvncStartCommand;
import org.apache.royale.test.ant.launcher.commands.headless.XvncStopCommand;
import org.apache.royale.test.ant.launcher.commands.process.ProcessCommand;
import org.apache.royale.test.ant.launcher.contexts.ProcessExecutionContext;
import org.apache.tools.ant.Project;

public class HeadlessContext
implements ProcessExecutionContext {
    private ProcessCommand playerCommand;
    private int startDisplay;
    private int finalDisplay;
    private Project project;

    public HeadlessContext(int display) {
        this.startDisplay = display;
    }

    @Override
    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    public void setCommand(ProcessCommand command) {
        this.playerCommand = command;
    }

    @Override
    public void start() throws IOException {
        XvncStartCommand xvncStart = new XvncStartCommand(this.startDisplay);
        xvncStart.setProject(this.project);
        LoggingUtil.log("Starting xvnc", true);
        while (xvncStart.execute() != 0) {
            LoggingUtil.log("Cannot start xnvc on :" + xvncStart.getCurrentDisplay() + ", cycling ...");
            try {
                xvncStart.cycle();
            }
            catch (XvncException xe) {
                throw new IOException(xe);
            }
        }
        this.finalDisplay = xvncStart.getCurrentDisplay();
        this.playerCommand.setEnvironment(new String[]{"DISPLAY=:" + this.finalDisplay});
        LoggingUtil.log("Setting DISPLAY=:" + this.finalDisplay);
        this.playerCommand.prepare();
    }

    @Override
    public void stop(Process playerProcess) throws IOException {
        if (playerProcess != null) {
            playerProcess.destroy();
        }
        XvncStopCommand xvncStop = new XvncStopCommand(this.finalDisplay);
        xvncStop.setProject(this.project);
        xvncStop.execute();
    }
}

