/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.fxg.sax;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.royale.compiler.fxg.FXGVersion;
import org.apache.royale.compiler.internal.fxg.sax.FXG_v1_0_Handler;
import org.apache.royale.compiler.internal.fxg.sax.FXG_v2_0_Handler;
import org.apache.royale.compiler.internal.fxg.sax.IFXGVersionHandler;

public class FXGVersionHandlerRegistry {
    private static HashMap<FXGVersion, IFXGVersionHandler> versionHandlers = new HashMap(4);
    public static FXGVersion defaultVersion = FXGVersion.v2_0;
    private static boolean registered = false;

    private static void registerKnownHandlers() {
        if (registered) {
            return;
        }
        FXGVersionHandlerRegistry.registerHandler(FXGVersion.v1_0, new FXG_v1_0_Handler());
        FXGVersionHandlerRegistry.registerHandler(FXGVersion.v2_0, new FXG_v2_0_Handler());
        registered = true;
    }

    protected static IFXGVersionHandler getDefaultHandler() {
        FXGVersionHandlerRegistry.registerKnownHandlers();
        return versionHandlers.get(defaultVersion);
    }

    protected static void registerHandler(FXGVersion version, IFXGVersionHandler obj) {
        if (versionHandlers != null) {
            IFXGVersionHandler vHandler = versionHandlers.get(version);
            FXGVersion fxgVersion = vHandler != null ? vHandler.getVersion() : version;
            versionHandlers.put(fxgVersion, obj);
        }
    }

    protected static void unregisterHandler(FXGVersion version) {
        IFXGVersionHandler vHandler;
        if (versionHandlers != null && (vHandler = versionHandlers.get(version)) != null) {
            FXGVersion fxgVersion = vHandler.getVersion();
            versionHandlers.remove(fxgVersion);
        }
    }

    protected static Set<FXGVersion> getVersionsForRegisteredHandlers() {
        if (versionHandlers == null) {
            return null;
        }
        FXGVersionHandlerRegistry.registerKnownHandlers();
        return versionHandlers.keySet();
    }

    protected static IFXGVersionHandler getVersionHandler(FXGVersion fxgVersion) {
        if (versionHandlers == null || fxgVersion == null) {
            return null;
        }
        Set<FXGVersion> versions = FXGVersionHandlerRegistry.getVersionsForRegisteredHandlers();
        for (FXGVersion version : versions) {
            if (!version.equalTo(fxgVersion)) continue;
            return versionHandlers.get(version);
        }
        for (FXGVersion version : versions) {
            if (version.getMajorVersion() != fxgVersion.getMajorVersion()) continue;
            return versionHandlers.get(version);
        }
        return null;
    }

    protected static IFXGVersionHandler getVersionHandler(double version) {
        FXGVersion fxgVersion = FXGVersion.newInstance(version);
        return FXGVersionHandlerRegistry.getVersionHandler(fxgVersion);
    }

    protected static IFXGVersionHandler getLatestVersionHandler() {
        if (versionHandlers == null) {
            return null;
        }
        Set<FXGVersion> versions = FXGVersionHandlerRegistry.getVersionsForRegisteredHandlers();
        Iterator<FXGVersion> iter = versions.iterator();
        FXGVersion latest = null;
        while (iter.hasNext()) {
            FXGVersion version = iter.next();
            if (latest == null) {
                latest = version;
                continue;
            }
            if (!version.greaterThan(latest)) continue;
            latest = version;
        }
        return versionHandlers.get(latest);
    }
}

