/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class NoStringEventNameRule
extends LinterRule {
    private static final String[] EVENT_DISPATCHER_FUNCTION_NAMES = new String[]{"addEventListener", "removeEventListener", "hasEventListener"};

    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.FunctionCallID, (node, tokenQuery, problems) -> this.checkFunctionCallNode((IFunctionCallNode)node, tokenQuery, problems));
        return result;
    }

    private void checkFunctionCallNode(IFunctionCallNode functionCallNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        IMemberAccessExpressionNode memberAccessNode;
        IExpressionNode rightNode;
        String functionName = null;
        IExpressionNode nameNode = functionCallNode.getNameNode();
        if (nameNode instanceof IIdentifierNode) {
            IIdentifierNode identifierNode = (IIdentifierNode)nameNode;
            functionName = identifierNode.getName();
        } else if (nameNode instanceof IMemberAccessExpressionNode && (rightNode = (memberAccessNode = (IMemberAccessExpressionNode)nameNode).getRightOperandNode()) instanceof IIdentifierNode) {
            IIdentifierNode identifierNode = (IIdentifierNode)rightNode;
            functionName = identifierNode.getName();
        }
        if (functionName == null) {
            return;
        }
        if (!Arrays.asList(EVENT_DISPATCHER_FUNCTION_NAMES).contains(functionName)) {
            return;
        }
        IExpressionNode[] argumentNodes = functionCallNode.getArgumentNodes();
        if (argumentNodes.length == 0) {
            return;
        }
        IExpressionNode firstArgument = argumentNodes[0];
        if (!(firstArgument instanceof ILiteralNode)) {
            return;
        }
        ILiteralNode literalNode = (ILiteralNode)firstArgument;
        if (!ILiteralNode.LiteralType.STRING.equals((Object)literalNode.getLiteralType())) {
            return;
        }
        problems.add(new NoStringEventNameLinterProblem(functionCallNode, functionName));
    }

    public static class NoStringEventNameLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Calls to '${functionName}' must use constant value instead of string literal for event name";
        public String functionName;

        public NoStringEventNameLinterProblem(IFunctionCallNode node, String functionName) {
            super((ISourceLocation)node.getArgumentNodes()[0]);
            this.functionName = functionName;
        }
    }
}

