/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.utils;

import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.servicecomb.swagger.generator.core.utils.ParamUtils;

public class MethodUtils {
    public static List<Method> findProducerMethods(Class<?> cls) {
        Method[] methods = cls.getMethods();
        ArrayList<Method> producerMethods = new ArrayList<Method>(methods.length);
        for (Method m : methods) {
            if (MethodUtils.isSkipMethod(cls, m)) continue;
            producerMethods.add(m);
        }
        producerMethods.sort(Comparator.comparing(ParamUtils::findSwaggerMethodName));
        return producerMethods;
    }

    public static boolean isSkipMethod(Class<?> cls, Method method) {
        if (method.getDeclaringClass() == Object.class) {
            return true;
        }
        if (method.getDeclaringClass().isInterface() && !cls.isInterface()) {
            return true;
        }
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return true;
        }
        if (method.isBridge()) {
            return true;
        }
        ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
        if (apiOperation != null && apiOperation.hidden()) {
            return apiOperation.hidden();
        }
        return false;
    }
}

