/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.policy;

import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.governance.policy.AbstractPolicy;
import org.springframework.util.CollectionUtils;

public class CircuitBreakerPolicy
extends AbstractPolicy {
    public static final float DEFAULT_FAILURE_RATE_THRESHOLD = 50.0f;
    public static final float DEFAULT_SLOW_CALL_RATE_THRESHOLD = 100.0f;
    public static final Duration DEFAULT_WAIT_DURATION_IN_OPEN_STATUS = Duration.ofMillis(60000L);
    public static final Duration DEFAULT_SLOW_CALL_DURATION_THRESHOLD = Duration.ofMillis(60000L);
    public static final int DEFAULT_PERMITTED = 10;
    public static final int DEFAULT_MINIMUM_NUMBER_CALLS = 100;
    public static final String DEFAULT_SLIDING_WINDOW_SIZE = "100";
    public static final String DEFAULT_FAILURE_RESPONSE_STATUS_502 = "502";
    public static final String DEFAULT_FAILURE_RESPONSE_STATUS_503 = "503";
    public static final List<String> DEFAULT_STATUS_LIST = Arrays.asList("502", "503");
    private float failureRateThreshold = 50.0f;
    private float slowCallRateThreshold = 100.0f;
    private String waitDurationInOpenState = DEFAULT_WAIT_DURATION_IN_OPEN_STATUS.toString();
    private String slowCallDurationThreshold = DEFAULT_SLOW_CALL_DURATION_THRESHOLD.toString();
    private int permittedNumberOfCallsInHalfOpenState = 10;
    private int minimumNumberOfCalls = 100;
    private String slidingWindowType;
    private String slidingWindowSize = "100";
    private List<String> recordFailureStatus = DEFAULT_STATUS_LIST;
    private boolean forceClosed = false;
    private boolean forceOpen = false;

    @Override
    public boolean isValid() {
        if (this.failureRateThreshold > 100.0f || this.failureRateThreshold <= 0.0f) {
            return false;
        }
        if (this.slowCallRateThreshold > 100.0f || this.slowCallRateThreshold <= 0.0f) {
            return false;
        }
        if (Duration.parse(this.waitDurationInOpenState).toMillis() <= 0L) {
            return false;
        }
        if (Duration.parse(this.slowCallDurationThreshold).toMillis() <= 0L) {
            return false;
        }
        if (this.permittedNumberOfCallsInHalfOpenState <= 0) {
            return false;
        }
        if (this.minimumNumberOfCalls <= 0) {
            return false;
        }
        return super.isValid();
    }

    public float getFailureRateThreshold() {
        return this.failureRateThreshold;
    }

    public void setFailureRateThreshold(float failureRateThreshold) {
        this.failureRateThreshold = failureRateThreshold;
    }

    public float getSlowCallRateThreshold() {
        return this.slowCallRateThreshold;
    }

    public void setSlowCallRateThreshold(float slowCallRateThreshold) {
        this.slowCallRateThreshold = slowCallRateThreshold;
    }

    public String getWaitDurationInOpenState() {
        return this.waitDurationInOpenState;
    }

    public void setWaitDurationInOpenState(String waitDurationInOpenState) {
        this.waitDurationInOpenState = this.stringOfDuration(waitDurationInOpenState, DEFAULT_WAIT_DURATION_IN_OPEN_STATUS);
    }

    public String getSlowCallDurationThreshold() {
        return this.slowCallDurationThreshold;
    }

    public void setSlowCallDurationThreshold(String slowCallDurationThreshold) {
        this.slowCallDurationThreshold = this.stringOfDuration(slowCallDurationThreshold, DEFAULT_SLOW_CALL_DURATION_THRESHOLD);
    }

    public int getPermittedNumberOfCallsInHalfOpenState() {
        return this.permittedNumberOfCallsInHalfOpenState;
    }

    public void setPermittedNumberOfCallsInHalfOpenState(int permittedNumberOfCallsInHalfOpenState) {
        this.permittedNumberOfCallsInHalfOpenState = permittedNumberOfCallsInHalfOpenState;
    }

    public int getMinimumNumberOfCalls() {
        return this.minimumNumberOfCalls;
    }

    public void setMinimumNumberOfCalls(int minimumNumberOfCalls) {
        this.minimumNumberOfCalls = minimumNumberOfCalls;
    }

    public CircuitBreakerConfig.SlidingWindowType getSlidingWindowTypeEnum() {
        if (StringUtils.isEmpty((CharSequence)this.slidingWindowType)) {
            return CircuitBreakerConfig.SlidingWindowType.TIME_BASED;
        }
        try {
            return CircuitBreakerConfig.SlidingWindowType.valueOf((String)this.slidingWindowType);
        }
        catch (Exception e) {
            return CircuitBreakerConfig.SlidingWindowType.TIME_BASED;
        }
    }

    public String getSlidingWindowType() {
        return this.slidingWindowType;
    }

    public void setSlidingWindowType(String slidingWindowType) {
        this.slidingWindowType = slidingWindowType;
    }

    public String getSlidingWindowSize() {
        return this.slidingWindowSize;
    }

    public void setSlidingWindowSize(String slidingWindowSize) {
        this.slidingWindowSize = this.getValue(slidingWindowSize);
    }

    private String getValue(String slidingWindowSize) {
        if (StringUtils.isEmpty((CharSequence)slidingWindowSize)) {
            return DEFAULT_SLIDING_WINDOW_SIZE;
        }
        if (slidingWindowSize.matches("-{0,1}[0-9]{1,10}")) {
            if (Long.parseLong(slidingWindowSize) < 0L) {
                throw new RuntimeException("The value should be more than 0.");
            }
            return slidingWindowSize;
        }
        Duration duration = Duration.parse("PT" + slidingWindowSize);
        return String.valueOf(duration.getSeconds());
    }

    public List<String> getRecordFailureStatus() {
        if (CollectionUtils.isEmpty(this.recordFailureStatus)) {
            return DEFAULT_STATUS_LIST;
        }
        return this.recordFailureStatus;
    }

    public void setRecordFailureStatus(List<String> recordFailureStatus) {
        if (recordFailureStatus == null) {
            return;
        }
        this.recordFailureStatus = recordFailureStatus.stream().filter(e -> !StringUtils.isEmpty((CharSequence)e)).collect(Collectors.toList());
    }

    public boolean isForceClosed() {
        return this.forceClosed;
    }

    public void setForceClosed(boolean forceClosed) {
        this.forceClosed = forceClosed;
    }

    public boolean isForceOpen() {
        return this.forceOpen;
    }

    public void setForceOpen(boolean forceOpen) {
        this.forceOpen = forceOpen;
    }

    public String toString() {
        return "CircuitBreakerPolicy{failureRateThreshold=" + this.failureRateThreshold + ", slowCallRateThreshold=" + this.slowCallRateThreshold + ", waitDurationInOpenState=" + this.waitDurationInOpenState + ", slowCallDurationThreshold=" + this.slowCallDurationThreshold + ", permittedNumberOfCallsInHalfOpenState=" + this.permittedNumberOfCallsInHalfOpenState + ", minimumNumberOfCalls=" + this.minimumNumberOfCalls + ", slidingWindowType='" + this.slidingWindowType + "', slidingWindowSize=" + this.slidingWindowSize + ", recordFailureStatus=" + this.recordFailureStatus + "}";
    }
}

