/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.converter.Converter;

public abstract class AbstractConverter
implements Converter {
    protected abstract Map<String, Object> findVendorExtensions(Object var1);

    protected abstract JavaType doConvert(OpenAPI var1, Schema var2);

    @Override
    public JavaType convert(OpenAPI swagger, Schema def) {
        Map<String, Object> vendorExtensions = this.findVendorExtensions(def);
        String canonical = SwaggerUtils.getClassName(vendorExtensions);
        if (StringUtils.isEmpty((CharSequence)canonical)) {
            return this.doConvert(swagger, def);
        }
        try {
            return TypeFactory.defaultInstance().constructFromCanonical(canonical);
        }
        catch (Throwable e) {
            return this.doConvert(swagger, def);
        }
    }
}

