/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.tracing.zipkin;

import brave.Tracing;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.apache.servicecomb.tracing.Span;
import org.apache.servicecomb.tracing.zipkin.ZipkinTracingAdviser;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
class ZipkinSpanAspect {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ZipkinTracingAdviser adviser;

    ZipkinSpanAspect(Tracing tracing) {
        this.adviser = new ZipkinTracingAdviser(tracing.tracer());
    }

    @Around(value="execution(@org.apache.servicecomb.tracing.Span * *(..)) && @annotation(spanAnnotation)")
    public Object advise(ProceedingJoinPoint joinPoint, Span spanAnnotation) throws Throwable {
        String spanName = spanAnnotation.spanName();
        String callPath = spanAnnotation.callPath();
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        LOG.debug("Generating zipkin span for method {}", (Object)method.toString());
        if ("".equals(spanName)) {
            spanName = method.getName();
        }
        if ("".equals(callPath)) {
            callPath = method.toString();
        }
        return this.adviser.invoke(spanName, callPath, () -> ((ProceedingJoinPoint)joinPoint).proceed());
    }
}

