/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight.store;

import com.google.common.base.Ticker;
import java.util.List;
import java.util.Objects;
import org.apache.servicecomb.registry.api.MicroserviceInstanceStatus;
import org.apache.servicecomb.registry.lightweight.model.MicroserviceInstance;

public class InstanceStore {
    private final Ticker ticker;
    private MicroserviceInstance instance;
    private long lastHeartBeat;

    public InstanceStore(Ticker ticker, MicroserviceInstance instance) {
        this.ticker = ticker;
        this.instance = instance;
        this.updateLastHeartBeat();
    }

    public boolean isStatusChanged(MicroserviceInstanceStatus status) {
        return !Objects.equals(this.instance.getStatus(), status);
    }

    public MicroserviceInstance getInstance() {
        return this.instance;
    }

    public InstanceStore setInstance(MicroserviceInstance instance) {
        this.instance = instance;
        return this;
    }

    public String getInstanceId() {
        return this.getInstance().getInstanceId();
    }

    public String getServiceId() {
        return this.getInstance().getServiceId();
    }

    public List<String> getEndpoints() {
        return this.getInstance().getEndpoints();
    }

    public MicroserviceInstanceStatus getStatus() {
        return this.instance.getStatus();
    }

    public void setStatus(MicroserviceInstanceStatus status) {
        this.instance.setStatus(status);
    }

    public void updateLastHeartBeat() {
        this.lastHeartBeat = this.ticker.read();
    }

    public long getLastHeartBeat() {
        return this.lastHeartBeat;
    }

    public boolean isHeartBeatTimeout(long nanoNow, long nanoTimeout) {
        return nanoNow - this.lastHeartBeat > nanoTimeout;
    }
}

