/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.springmvc.processor.annotation;

import java.util.Arrays;
import org.apache.servicecomb.swagger.generator.MethodAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.springframework.web.bind.annotation.RequestMethod;

abstract class AbstractHttpMethodMappingAnnotationProcessor<ANNOTATION>
implements MethodAnnotationProcessor<ANNOTATION> {
    AbstractHttpMethodMappingAnnotationProcessor() {
    }

    protected void doProcess(OperationGenerator operationGenerator, String[] paths, String[] pathValues, RequestMethod requestMethod, String[] consumes, String[] produces) {
        this.processPath(operationGenerator, paths);
        this.processPath(operationGenerator, pathValues);
        if (requestMethod != null) {
            operationGenerator.setHttpMethod(requestMethod.name());
        }
        if (consumes.length > 0) {
            operationGenerator.getOperationGeneratorContext().updateConsumes(Arrays.asList(consumes));
        }
        if (produces.length > 0) {
            operationGenerator.getOperationGeneratorContext().updateProduces(Arrays.asList(produces));
        }
    }

    protected void processPath(OperationGenerator operationGenerator, String[] paths) {
        if (null == paths || paths.length == 0) {
            return;
        }
        if (paths.length > 1) {
            throw new IllegalStateException("not allowed multi path.");
        }
        operationGenerator.setPath(paths[0]);
    }
}

