/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.nacos;

import org.springframework.core.env.Environment;

public class NacosConfig {
    public static final String PROPERTY_DATA_ID = "servicecomb.nacos.dataId";
    public static final String PROPERTY_SERVER_ADDR = "servicecomb.nacos.serverAddr";
    public static final String PROPERTY_GROUP = "servicecomb.nacos.group";
    public static final String PROPERTY_ADD_PREFIX = "servicecomb.nacos.addPrefix";
    public static final String PROPERTY_CONTENT_TYPE = "servicecomb.nacos.contentType";
    public static final String PROPERTY_USERNAME = "servicecomb.nacos.username";
    public static final String PROPERTY_PASSWORD = "servicecomb.nacos.password";
    public static final String PROPERTY_ACCESS_KEY = "servicecomb.nacos.accessKey";
    public static final String PROPERTY_SECRET_KEY = "servicecomb.nacos.secretKey";
    public static final String PROP_NAMESPACE = "namespace";
    public static final String PROP_ADDRESS = "serverAddr";
    public static final String PROP_USERNAME = "username";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_ACCESS_KEY = "accessKey";
    public static final String PROP_SECRET_KEY = "secretKey";
    private final Environment environment;

    public NacosConfig(Environment environment) {
        this.environment = environment;
    }

    public String getServerAddr() {
        return this.environment.getProperty(PROPERTY_SERVER_ADDR, "http://127.0.0.1:8848");
    }

    public String getDataId() {
        return this.environment.getProperty(PROPERTY_DATA_ID);
    }

    public String getGroup() {
        return this.environment.getProperty(PROPERTY_GROUP);
    }

    public String getUsername() {
        return this.environment.getProperty(PROPERTY_USERNAME);
    }

    public String getPassword() {
        return this.environment.getProperty(PROPERTY_PASSWORD);
    }

    public String getAccessKey() {
        return this.environment.getProperty(PROPERTY_ACCESS_KEY);
    }

    public String getSecretKey() {
        return this.environment.getProperty(PROPERTY_SECRET_KEY);
    }

    public String getContentType() {
        return this.environment.getProperty(PROPERTY_CONTENT_TYPE, "yaml");
    }

    public boolean getAddPrefix() {
        return (Boolean)this.environment.getProperty(PROPERTY_ADD_PREFIX, Boolean.TYPE, (Object)false);
    }
}

