/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.generator.annotation;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import org.apache.servicecomb.toolkit.generator.annotation.ParamAnnotationProcessor;
import org.apache.servicecomb.toolkit.generator.context.ParameterContext;
import org.apache.servicecomb.toolkit.generator.util.SwaggerAnnotationUtils;

public class ParameterAnnotationProcessor
implements ParamAnnotationProcessor<Parameter, ParameterContext> {
    @Override
    public void process(Parameter parameterAnnotation, ParameterContext paramCtx) {
        Schema schema = parameterAnnotation.schema();
        io.swagger.v3.oas.models.media.Schema schemaFromAnnotation = SwaggerAnnotationUtils.getSchemaFromAnnotation(schema);
        if (schemaFromAnnotation != null) {
            paramCtx.setSchema(schemaFromAnnotation);
        }
        paramCtx.setRequired(parameterAnnotation.required());
        paramCtx.setAllowEmptyValue(parameterAnnotation.allowEmptyValue());
        paramCtx.setAllowReserved(parameterAnnotation.allowReserved());
        paramCtx.setDeprecated(parameterAnnotation.deprecated());
        paramCtx.setExample(parameterAnnotation.example());
        switch (parameterAnnotation.in()) {
            case HEADER: {
                paramCtx.setIn(ParameterContext.InType.HEADER);
                break;
            }
            case COOKIE: {
                paramCtx.setIn(ParameterContext.InType.COOKIE);
                break;
            }
            case PATH: {
                paramCtx.setIn(ParameterContext.InType.PATH);
                break;
            }
            default: {
                paramCtx.setIn(ParameterContext.InType.QUERY);
            }
        }
        paramCtx.setDescription(parameterAnnotation.description());
        paramCtx.setRef(parameterAnnotation.ref());
        paramCtx.setName(parameterAnnotation.name());
        paramCtx.setExplode(this.getExplode(parameterAnnotation.explode()));
        paramCtx.applyAnnotations(Collections.singletonList(parameterAnnotation));
    }

    private Boolean getExplode(Explode explode) {
        switch (explode) {
            case TRUE: {
                return true;
            }
        }
        return false;
    }
}

