/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public final class FilePerm {
    public static final int FILE_PERM_UREAD = 256;
    public static final int FILE_PERM_UWRITE = 128;
    public static final int FILE_PERM_UEXEC = 64;
    public static final int FILE_PERM_GREAD = 32;
    public static final int FILE_PERM_GWRITE = 16;
    public static final int FILE_PERM_GEXEC = 8;
    public static final int FILE_PERM_OREAD = 4;
    public static final int FILE_PERM_OWRITE = 2;
    public static final int FILE_PERM_OEXEC = 1;
    public static final int FILE_PERM_MASK = 511;
    private static AclEntryPermission[] permList = new AclEntryPermission[]{AclEntryPermission.READ_DATA, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.READ_ACL, AclEntryPermission.WRITE_DATA, AclEntryPermission.APPEND_DATA, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.WRITE_ACL, AclEntryPermission.SYNCHRONIZE};

    private FilePerm() {
    }

    public static Set<PosixFilePermission> getDefaultPosixPerm() {
        return PosixFilePermissions.fromString("rw-r-----");
    }

    public static Set<PosixFilePermission> getPosixPerm(int perm) {
        StringBuilder permStr = new StringBuilder();
        permStr.append(FilePerm.uCanRead(perm) ? "r" : "-");
        permStr.append(FilePerm.uCanWrite(perm) ? "w" : "-");
        permStr.append(FilePerm.uCanExec(perm) ? "x" : "-");
        permStr.append(FilePerm.gCanRead(perm) ? "r" : "-");
        permStr.append(FilePerm.gCanWrite(perm) ? "w" : "-");
        permStr.append(FilePerm.gCanExec(perm) ? "x" : "-");
        permStr.append(FilePerm.oCanRead(perm) ? "r" : "-");
        permStr.append(FilePerm.oCanWrite(perm) ? "w" : "-");
        permStr.append(FilePerm.oCanExec(perm) ? "x" : "-");
        return PosixFilePermissions.fromString(permStr.toString());
    }

    public static Set<AclEntryPermission> getDefaultAclPerm() {
        EnumSet<AclEntryPermission> perms = EnumSet.noneOf(AclEntryPermission.class);
        perms.addAll(Arrays.asList(permList));
        return perms;
    }

    public static boolean uCanRead(int perm) {
        return (0x100 & perm) > 0;
    }

    public static boolean uCanWrite(int perm) {
        return (0x80 & perm) > 0;
    }

    public static boolean uCanExec(int perm) {
        return (0x40 & perm) > 0;
    }

    public static boolean gCanRead(int perm) {
        return (0x20 & perm) > 0;
    }

    public static boolean gCanWrite(int perm) {
        return (0x10 & perm) > 0;
    }

    public static boolean gCanExec(int perm) {
        return (8 & perm) > 0;
    }

    public static boolean oCanRead(int perm) {
        return (0x20 & perm) > 0;
    }

    public static boolean oCanWrite(int perm) {
        return (0x10 & perm) > 0;
    }

    public static boolean oCanExec(int perm) {
        return (8 & perm) > 0;
    }

    public static void setFilePerm(File file, String perm) {
        if (FilePerm.filePermSupported()) {
            try {
                Set<PosixFilePermission> perms = PosixFilePermissions.fromString(perm);
                PosixFileAttributes attr = Files.readAttributes(file.toPath(), PosixFileAttributes.class, new LinkOption[0]);
                attr.permissions().clear();
                Files.setPosixFilePermissions(file.toPath(), perms);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static boolean filePermSupported() {
        FileSystem system = FileSystems.getDefault();
        for (String name : system.supportedFileAttributeViews()) {
            if (!"posix".equals(name)) continue;
            return true;
        }
        return false;
    }
}

