/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime;

import java.util.Collections;
import java.util.Map;
import org.apache.felix.http.base.internal.runtime.AbstractInfo;
import org.apache.felix.http.base.internal.util.PatternUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.context.ServletContextHelper;

public final class ServletContextHelperInfo
extends AbstractInfo<ServletContextHelper> {
    private static final String CONTEXT_INIT_PREFIX = "context.init.";
    private final String name;
    private final String path;
    private final Map<String, String> initParams;

    public ServletContextHelperInfo(ServiceReference<ServletContextHelper> ref) {
        super(ref);
        this.name = this.getStringProperty(ref, "osgi.http.whiteboard.context.name");
        this.path = this.getStringProperty(ref, "osgi.http.whiteboard.context.path");
        this.initParams = this.getInitParams(ref, CONTEXT_INIT_PREFIX);
    }

    public ServletContextHelperInfo(int serviceRanking, long serviceId, String name, String path, Map<String, String> initParams) {
        super(serviceRanking, serviceId);
        this.name = name;
        this.path = path;
        this.initParams = initParams == null ? Collections.emptyMap() : Collections.unmodifiableMap(initParams);
    }

    private boolean isValidPath() {
        if (!this.isEmpty(this.path)) {
            if (this.path.equals("/")) {
                return true;
            }
            if (this.path.startsWith("/") && !this.path.endsWith("/")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && PatternUtil.isValidSymbolicName(this.name) && !"org.osgi.service.http".equals(this.name) && this.isValidPath();
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getInitParameters() {
        return this.initParams;
    }
}

