/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Components supporting the {@link org.apache.shiro.subject.Subject Subject} interface, the most important concept in
 * Shiro's API.
 * <p/>
 * A <code>Subject</code> is <em>the</em> primary component when using Shiro programmatically for single-user
 * security operations, and it is the handle to any accessible user security data.  All single-user
 * authentication, authorization and session operations are performed via a <code>Subject</code> instance.
 */
package org.apache.shiro.subject;
