/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import java.util.regex.Pattern;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.MeridianArcBased;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.projection.ProjectionVariant;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class Sinusoidal
extends MeridianArcBased {
    private static final long serialVersionUID = 7908925241331303236L;
    private final Variant variant;

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        Variant variant = (Variant)Sinusoidal.variant((OperationMethod)method, (ProjectionVariant[])Variant.values(), null);
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.referencing.operation.provider.Sinusoidal.CENTRAL_MERIDIAN);
        roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.referencing.operation.provider.Sinusoidal.FALSE_EASTING);
        roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.referencing.operation.provider.Sinusoidal.FALSE_NORTHING);
        return new Initializer(method, parameters, roles, variant);
    }

    public Sinusoidal(OperationMethod method, Parameters parameters) {
        this(Sinusoidal.initializer(method, parameters));
    }

    private Sinusoidal(Initializer initializer) {
        super(initializer);
        this.variant = (Variant)initializer.variant;
    }

    Sinusoidal(Sinusoidal other) {
        super(other);
        this.variant = other.variant;
    }

    @Override
    public MathTransform createMapProjection(MathTransformProvider.Context parameters) throws FactoryException {
        Sinusoidal kernel = this;
        if (this.eccentricity == 0.0 || this.variant == Variant.PSEUDO) {
            kernel = new Spherical(this);
        }
        return this.context.completeTransform(parameters.getFactory(), kernel);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03bb = srcPts[srcOff];
        double \u03c6 = srcPts[srcOff + 1];
        double cos\u03c6 = Math.cos(\u03c6);
        double sin\u03c6 = Math.sin(\u03c6);
        double sin\u03c62 = sin\u03c6 * sin\u03c6;
        double r\u03bd2 = 1.0 - this.eccentricitySquared * sin\u03c62;
        double r\u03bd = Math.sqrt(r\u03bd2);
        double dx_d\u03bb = cos\u03c6 / r\u03bd;
        if (dstPts != null) {
            dstPts[dstOff] = dx_d\u03bb * \u03bb;
            dstPts[dstOff + 1] = this.distance(\u03c6, sin\u03c6, cos\u03c6);
        }
        if (!derivate) {
            return null;
        }
        double dx_d\u03c6 = \u03bb * sin\u03c6 * (this.eccentricitySquared * (cos\u03c6 * cos\u03c6) / r\u03bd2 - 1.0) / r\u03bd;
        return new Matrix2(dx_d\u03bb, dx_d\u03c6, 0.0, this.dM_d\u03c6(sin\u03c62));
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) {
        double x = srcPts[srcOff];
        double y = srcPts[srcOff + 1];
        double \u03c6 = this.latitude(y);
        double sin\u03c6 = Math.sin(\u03c6);
        dstPts[dstOff] = x * Math.sqrt(1.0 - this.eccentricitySquared * (sin\u03c6 * sin\u03c6)) / Math.cos(\u03c6);
        dstPts[dstOff + 1] = \u03c6;
    }

    private static enum Variant implements ProjectionVariant
    {
        PSEUDO(".*\\bPseudo.*");

        private final Pattern operationName;

        private Variant(String operationName) {
            this.operationName = Pattern.compile(operationName, 2);
        }

        @Override
        public Pattern getOperationNamePattern() {
            return this.operationName;
        }
    }

    private static final class Spherical
    extends Sinusoidal {
        private static final long serialVersionUID = -5843301120207230310L;

        Spherical(Sinusoidal other) {
            super(other);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
            double \u03bb = srcPts[srcOff];
            double \u03c6 = srcPts[srcOff + 1];
            double cos\u03c6 = Math.cos(\u03c6);
            if (dstPts != null) {
                dstPts[dstOff] = \u03bb * cos\u03c6;
                dstPts[dstOff + 1] = \u03c6;
            }
            return derivate ? new Matrix2(cos\u03c6, -\u03bb * Math.sin(\u03c6), 0.0, 1.0) : null;
        }

        @Override
        public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            if (srcPts != dstPts || srcOff != dstOff) {
                super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
            } else {
                while (--numPts >= 0) {
                    int n = dstOff;
                    dstPts[n] = dstPts[n] * Math.cos(dstPts[dstOff + 1]);
                    dstOff += 2;
                }
            }
        }

        @Override
        protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) {
            double x = srcPts[srcOff];
            double \u03c6 = srcPts[srcOff + 1];
            dstPts[dstOff] = x / Math.cos(\u03c6);
            dstPts[dstOff + 1] = \u03c6;
        }
    }
}

