/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.AxisOrderReversal3D;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

@XmlTransient
public class AxisOrderReversal
extends AbstractProvider {
    private static final long serialVersionUID = -5657908757386024307L;
    private static final ParameterDescriptorGroup PARAMETERS = ((ParameterBuilder)((ParameterBuilder)AxisOrderReversal.builder().addIdentifier("9843")).addName("Axis Order Reversal (2D)")).createGroup(new GeneralParameterDescriptor[0]);
    private static final AxisOrderReversal INSTANCE = new AxisOrderReversal();

    public static AxisOrderReversal provider() {
        return INSTANCE;
    }

    public AxisOrderReversal() {
        this(PARAMETERS, 2);
    }

    AxisOrderReversal(ParameterDescriptorGroup parameters, byte dimension) {
        super(Conversion.class, parameters, CoordinateSystem.class, false, CoordinateSystem.class, false, dimension);
    }

    @Override
    public AbstractProvider variantFor(MathTransform transform) {
        int dimension = AxisOrderReversal.maxDimension(transform);
        if (dimension != this.minSourceDimension) {
            return dimension >= 3 ? AxisOrderReversal3D.INSTANCE : INSTANCE;
        }
        return this;
    }

    @Override
    public MathTransform createMathTransform(MathTransformProvider.Context context) throws FactoryException {
        int sourceDimensions = context.getSourceDimensions().orElse(this.minSourceDimension);
        int targetDimensions = context.getTargetDimensions().orElse(this.minSourceDimension);
        MatrixSIS m = Matrices.createZero(targetDimensions + 1, sourceDimensions + 1);
        m.setElement(0, 1, 1.0);
        m.setElement(1, 0, 1.0);
        m.setElement(targetDimensions, sourceDimensions, 1.0);
        int i = Math.min(targetDimensions, sourceDimensions);
        while (--i >= 2) {
            m.setElement(i, i, 1.0);
        }
        return context.getFactory().createAffineTransform((Matrix)m);
    }

    @Override
    public AbstractProvider inverse() {
        return this;
    }
}

