/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Optional;
import org.apache.sis.filter.Expression;
import org.apache.sis.style.se1.ContrastEnhancement;
import org.apache.sis.style.se1.StyleElement;
import org.apache.sis.style.se1.StyleFactory;

@XmlType(name="SelectedChannelType", propOrder={"sourceChannelName", "contrastEnhancement"})
public class SelectedChannel<R>
extends StyleElement<R> {
    @XmlElement(name="SourceChannelName", required=true)
    protected Expression<R, String> sourceChannelName;
    @XmlElement(name="ContrastEnhancement")
    protected ContrastEnhancement<R> contrastEnhancement;

    private SelectedChannel() {
    }

    public SelectedChannel(StyleFactory<R> factory) {
        super(factory);
    }

    public SelectedChannel(SelectedChannel<R> source) {
        super(source);
        this.sourceChannelName = source.sourceChannelName;
        this.contrastEnhancement = source.contrastEnhancement;
    }

    public Expression<R, String> getSourceChannelName() {
        return this.sourceChannelName;
    }

    public void setSourceChannelName(Expression<R, String> value) {
        this.sourceChannelName = value;
    }

    public Optional<ContrastEnhancement<R>> getContrastEnhancement() {
        return Optional.ofNullable(this.contrastEnhancement);
    }

    public void setContrastEnhancement(ContrastEnhancement<R> value) {
        this.contrastEnhancement = value;
    }

    @Override
    final Object[] properties() {
        return new Object[]{this.sourceChannelName, this.contrastEnhancement};
    }

    @Override
    public SelectedChannel<R> clone() {
        SelectedChannel clone = (SelectedChannel)super.clone();
        clone.selfClone();
        return clone;
    }

    private void selfClone() {
        if (this.contrastEnhancement != null) {
            this.contrastEnhancement = this.contrastEnhancement.clone();
        }
    }
}

