/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.annotation.XmlTransient;
import java.awt.Color;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.filter.Expression;
import org.apache.sis.style.se1.StyleFactory;

@XmlTransient
public abstract class StyleElement<R>
implements Cloneable {
    protected final StyleFactory<R> factory;

    StyleElement(StyleFactory<R> factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    StyleElement(StyleElement<R> source) {
        this.factory = source.factory;
    }

    StyleElement() {
        this.factory = null;
    }

    public final <E> Expression<R, E> literal(E value) {
        return value == null ? null : this.factory.filterFactory.literal(value);
    }

    protected final Expression<R, Boolean> defaultToTrue(Expression<R, Boolean> value) {
        return value != null ? value : this.factory.enabled;
    }

    protected final Expression<R, Boolean> defaultToFalse(Expression<R, Boolean> value) {
        return value != null ? value : this.factory.disabled;
    }

    protected final Expression<R, ? extends Number> defaultToZero(Expression<R, ? extends Number> value) {
        return value != null ? value : this.factory.zero;
    }

    protected final Expression<R, ? extends Number> defaultToHalf(Expression<R, ? extends Number> value) {
        return value != null ? value : this.factory.half;
    }

    protected final Expression<R, ? extends Number> defaultToOne(Expression<R, ? extends Number> value) {
        return value != null ? value : this.factory.one;
    }

    final Expression<R, ? extends Number> opacity(Color color) {
        int alpha = color.getAlpha();
        return alpha != 255 ? this.literal((double)alpha / 256.0) : null;
    }

    abstract Object[] properties();

    public int hashCode() {
        return this.getClass().hashCode() + Arrays.hashCode(this.properties());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj != null && obj.getClass() == this.getClass() && Arrays.equals(this.properties(), ((StyleElement)obj).properties());
    }

    public StyleElement<R> clone() {
        try {
            return (StyleElement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

