/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.csv;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import org.apache.sis.converter.SurjectiveConverter;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.temporal.LenientDateFormat;
import org.apache.sis.temporal.TemporalDate;
import org.opengis.referencing.datum.TemporalDatum;

class TimeEncoding
extends SurjectiveConverter<String, Instant> {
    static final CommonCRS.Temporal DEFAULT = CommonCRS.Temporal.TRUNCATED_JULIAN;
    static final TimeEncoding ABSOLUTE = new TimeEncoding(DEFAULT.datum(), Units.DAY){

        @Override
        public Instant apply(String time) {
            return LenientDateFormat.parseInstantUTC((CharSequence)time);
        }
    };
    private final Instant origin;
    private final double interval;

    TimeEncoding(TemporalDatum datum, Unit<Time> unit) {
        this.origin = TemporalDate.toInstant((Date)datum.getOrigin());
        this.interval = unit.getConverterTo(Units.SECOND).convert(1.0);
    }

    public final Class<String> getSourceClass() {
        return String.class;
    }

    public final Class<Instant> getTargetClass() {
        return Instant.class;
    }

    public Instant apply(String time) {
        return TemporalDate.addSeconds((Instant)this.origin, (double)(Double.parseDouble(time) * this.interval));
    }

    final double toCRS(Instant time) {
        return (double)this.origin.until(time, ChronoUnit.SECONDS) / this.interval;
    }
}

