/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;

public class AbstractIdentifiedType
implements Deprecable,
Serializable {
    private static final long serialVersionUID = 277130188958446740L;
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.feature");
    public static final String NAME_KEY = "name";
    public static final String DEFINITION_KEY = "definition";
    public static final String DESIGNATION_KEY = "designation";
    public static final String DESCRIPTION_KEY = "description";
    public static final String DEPRECATED_KEY = "deprecated";
    public static final String INHERIT_FROM_KEY = "inheritFrom";
    private final GenericName name;
    private final InternationalString definition;
    private final InternationalString designation;
    private final InternationalString description;
    final boolean deprecated;

    protected AbstractIdentifiedType(Map<String, ?> identification) throws IllegalArgumentException {
        AbstractIdentifiedType inheritFrom = (AbstractIdentifiedType)Containers.property(identification, (Object)INHERIT_FROM_KEY, AbstractIdentifiedType.class);
        Object value = identification.get(NAME_KEY);
        if (value == null) {
            if (inheritFrom == null || (this.name = inheritFrom.getName()) == null) {
                throw new IllegalArgumentException(Errors.forProperties(identification).getString((short)111, (Object)NAME_KEY));
            }
        } else if (value instanceof String) {
            this.name = this.createName((NameFactory)DefaultNameFactory.provider(), (String)value);
        } else if (value instanceof GenericName) {
            this.name = (GenericName)value;
        } else {
            throw AbstractIdentifiedType.illegalPropertyType(identification, NAME_KEY, value);
        }
        this.definition = AbstractIdentifiedType.toInternationalString(identification, DEFINITION_KEY, inheritFrom);
        this.designation = AbstractIdentifiedType.toInternationalString(identification, DESIGNATION_KEY, inheritFrom);
        this.description = AbstractIdentifiedType.toInternationalString(identification, DESCRIPTION_KEY, inheritFrom);
        value = identification.get(DEPRECATED_KEY);
        if (value == null) {
            this.deprecated = inheritFrom != null && inheritFrom.isDeprecated();
        } else if (value instanceof Boolean) {
            this.deprecated = (Boolean)value;
        } else {
            throw AbstractIdentifiedType.illegalPropertyType(identification, DEPRECATED_KEY, value);
        }
    }

    private static InternationalString toInternationalString(Map<String, ?> identification, String prefix, AbstractIdentifiedType inheritFrom) {
        InternationalString i18n = Types.toInternationalString(identification, (String)prefix);
        if (i18n == null && inheritFrom != null) {
            switch (prefix) {
                case "definition": {
                    i18n = inheritFrom.getDefinition();
                    break;
                }
                case "designation": {
                    i18n = inheritFrom.getDesignation().orElse(null);
                    break;
                }
                case "description": {
                    i18n = inheritFrom.getDescription().orElse(null);
                }
            }
        }
        return i18n;
    }

    private static IllegalArgumentException illegalPropertyType(Map<String, ?> identification, String key, Object value) {
        return new IllegalArgumentException(Errors.forProperties(identification).getString((short)73, (Object)key, value.getClass()));
    }

    final Map<String, ?> inherit() {
        return Map.of(INHERIT_FROM_KEY, this);
    }

    GenericName createName(NameFactory factory, String value) {
        return factory.createLocalName(null, (CharSequence)value);
    }

    public final GenericName getName() {
        return this.name;
    }

    public InternationalString getDefinition() {
        return this.definition;
    }

    public Optional<InternationalString> getDesignation() {
        return Optional.ofNullable(this.designation);
    }

    public Optional<InternationalString> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public InternationalString getRemarks() {
        return this.deprecated ? this.description : null;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.definition, this.designation, this.description, this.deprecated);
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            AbstractIdentifiedType that = (AbstractIdentifiedType)obj;
            return Objects.equals(this.name, that.name) && Objects.equals(this.definition, that.definition) && Objects.equals(this.designation, that.designation) && Objects.equals(this.description, that.description) && this.deprecated == that.deprecated;
        }
        return false;
    }

    static String toString(GenericName name, AbstractIdentifiedType container, String argument, int index) {
        short key = 111;
        if (name != null) {
            String s = name.toString();
            if (!s.isEmpty()) {
                return s;
            }
            key = 47;
        }
        StringBuilder b = new StringBuilder(40).append("Type[\u201c").append(container.getName()).append("\u201d].").append(argument).append('[').append(index).append("].name");
        throw new IllegalArgumentException(Errors.format((short)key, (Object)b.toString()));
    }
}

